/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import java.util.Optional;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.webmvc.json.MappedJackson3Properties;
import org.springframework.data.rest.webmvc.json.patch.BindContext;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.util.Assert;
import tools.jackson.databind.ObjectMapper;

class JacksonBindContext
implements BindContext {
    private final PersistentEntities entities;
    private final ObjectMapper mapper;
    private final EvaluationContext context;

    public JacksonBindContext(PersistentEntities entities, ConversionService conversionService, ObjectMapper mapper) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        this.entities = entities;
        this.mapper = mapper;
        this.context = SimpleEvaluationContext.forReadWriteDataBinding().withConversionService(conversionService).build();
    }

    @Override
    public Optional<String> getReadableProperty(String segment, Class<?> type) {
        return JacksonBindContext.getProperty(this.entities.getPersistentEntity(type).map(it -> MappedJackson3Properties.forSerialization(it, this.mapper)).filter(it -> it.isReadableField(segment)), segment);
    }

    @Override
    public Optional<String> getWritableProperty(String segment, Class<?> type) {
        return JacksonBindContext.getProperty(this.entities.getPersistentEntity(type).map(it -> MappedJackson3Properties.forDeserialization(it, this.mapper)).filter(it -> it.isWritableField(segment)), segment);
    }

    @Override
    public EvaluationContext getEvaluationContext() {
        return this.context;
    }

    private static Optional<String> getProperty(Optional<MappedJackson3Properties> properties, String segment) {
        return properties.map(it -> it.getPersistentProperty(segment)).map(PersistentProperty::getName);
    }
}

