/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.geo;

import org.springframework.data.solr.core.geo.GeoLocation;
import org.springframework.util.Assert;

public class BoundingBox {
    private GeoLocation geoLocationStart;
    private GeoLocation geoLocationEnd;

    private BoundingBox() {
    }

    public BoundingBox(GeoLocation geoLocationStart, GeoLocation geoLocationEnd) {
        Assert.notNull((Object)geoLocationStart);
        Assert.notNull((Object)geoLocationEnd);
        this.geoLocationStart = geoLocationStart;
        this.geoLocationEnd = geoLocationEnd;
    }

    public static Builder startingAt(GeoLocation start) {
        return new Builder(start);
    }

    public GeoLocation getGeoLocationStart() {
        return this.geoLocationStart;
    }

    public void setGeoLocationStart(GeoLocation geoLocationStart) {
        this.geoLocationStart = geoLocationStart;
    }

    public GeoLocation getGeoLocationEnd() {
        return this.geoLocationEnd;
    }

    public void setGeoLocationEnd(GeoLocation geoLocationEnd) {
        this.geoLocationEnd = geoLocationEnd;
    }

    public static class Builder {
        private BoundingBox bbox;

        public Builder(GeoLocation start) {
            Assert.notNull((Object)start);
            this.bbox = new BoundingBox();
            this.bbox.geoLocationStart = start;
        }

        public BoundingBox endingAt(GeoLocation end) {
            Assert.notNull((Object)end);
            this.bbox.geoLocationEnd = end;
            return this.bbox;
        }
    }
}

