/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.geo;

public class Distance {
    private final double value;
    private final Unit unit;

    public Distance(double value) {
        this(value, Unit.KILOMETERS);
    }

    public Distance(double value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    public double getValue() {
        return this.value;
    }

    public double getNormalizedValue() {
        return this.unit != null ? this.unit.getMultiplier() * this.value : this.value * Unit.KILOMETERS.getMultiplier();
    }

    public static enum Unit {
        KILOMETERS(1.0),
        MILES(1.609344);

        private final double multiplier;

        private Unit(double multiplier) {
            this.multiplier = multiplier;
        }

        public double getMultiplier() {
            return this.multiplier;
        }
    }
}

