/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.solr.core.query.AbstractQuery;
import org.springframework.data.solr.core.query.Criteria;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.FilterQuery;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.util.Assert;

public class SimpleQuery
extends AbstractQuery
implements Query,
FilterQuery {
    public static final Pageable DEFAULT_PAGE = new PageRequest(0, 10);
    private List<Field> projectionOnFields = new ArrayList<Field>(0);
    private List<Field> groupByFields = new ArrayList<Field>(0);
    private List<FilterQuery> filterQueries = new ArrayList<FilterQuery>(0);
    private Pageable pageable = DEFAULT_PAGE;
    private Sort sort;
    private Query.Operator defaultOperator;
    private Integer timeAllowed;
    private String defType;

    public SimpleQuery() {
    }

    public SimpleQuery(Criteria criteria) {
        this(criteria, null);
    }

    public SimpleQuery(Criteria criteria, Pageable pageable) {
        super(criteria);
        this.pageable = pageable;
        if (pageable != null) {
            this.addSort(pageable.getSort());
        }
    }

    public static final Query fromQuery(Query source) {
        return SimpleQuery.fromQuery(source, new SimpleQuery());
    }

    public static <T extends SimpleQuery> T fromQuery(Query source, T destination) {
        if (source == null || destination == null) {
            return null;
        }
        if (source.getCriteria() != null) {
            destination.addCriteria(source.getCriteria());
        }
        if (!source.getFilterQueries().isEmpty()) {
            for (FilterQuery fq : source.getFilterQueries()) {
                destination.addFilterQuery(fq);
            }
        }
        if (!source.getProjectionOnFields().isEmpty()) {
            for (Field projectionField : source.getProjectionOnFields()) {
                destination.addProjectionOnField(projectionField);
            }
        }
        if (!source.getGroupByFields().isEmpty()) {
            for (Field groupByField : source.getGroupByFields()) {
                destination.addGroupByField(groupByField);
            }
        }
        if (source.getSort() != null) {
            destination.addSort(source.getSort());
        }
        if (source.getDefType() != null) {
            destination.setDefType(source.getDefType());
        }
        if (source.getDefaultOperator() != null) {
            destination.setDefaultOperator(source.getDefaultOperator());
        }
        if (source.getTimeAllowed() != null) {
            destination.setTimeAllowed(source.getTimeAllowed());
        }
        if (source.getRequestHandler() != null) {
            destination.setRequestHandler(source.getRequestHandler());
        }
        return destination;
    }

    @Override
    public final <T extends Query> T addProjectionOnField(Field field) {
        Assert.notNull((Object)field, (String)"Field for projection must not be null.");
        Assert.hasText((String)field.getName(), (String)"Field.name for projection must not be null/empty.");
        this.projectionOnFields.add(field);
        return (T)this;
    }

    public final <T extends Query> T addProjectionOnField(String fieldname) {
        return this.addProjectionOnField(new SimpleField(fieldname));
    }

    public final <T extends Query> T addProjectionOnFields(Field ... fields) {
        Assert.notEmpty((Object[])fields, (String)"Cannot add projection on null/empty field list.");
        for (Field field : fields) {
            this.addProjectionOnField(field);
        }
        return (T)this;
    }

    public final <T extends Query> T addProjectionOnFields(String ... fieldnames) {
        Assert.notEmpty((Object[])fieldnames, (String)"Cannot add projection on null/empty field list.");
        for (String fieldname : fieldnames) {
            this.addProjectionOnField(fieldname);
        }
        return (T)this;
    }

    @Override
    public final <T extends Query> T setPageRequest(Pageable pageable) {
        Assert.notNull((Object)pageable);
        this.pageable = pageable;
        return this.addSort(pageable.getSort());
    }

    @Override
    public final <T extends Query> T addGroupByField(Field field) {
        Assert.notNull((Object)field, (String)"Field for grouping must not be null.");
        Assert.hasText((String)field.getName(), (String)"Field.name for grouping must not be null/empty.");
        this.groupByFields.add(field);
        return (T)this;
    }

    public final <T extends Query> T addGroupByField(String fieldname) {
        return this.addGroupByField(new SimpleField(fieldname));
    }

    @Override
    public final <T extends Query> T addSort(Sort sort) {
        if (sort == null) {
            return (T)this;
        }
        this.sort = this.sort == null ? sort : this.sort.and(sort);
        return (T)this;
    }

    @Override
    public Sort getSort() {
        return this.sort;
    }

    @Override
    public Pageable getPageRequest() {
        return this.pageable;
    }

    @Override
    public List<Field> getGroupByFields() {
        return Collections.unmodifiableList(this.groupByFields);
    }

    @Override
    public List<Field> getProjectionOnFields() {
        return Collections.unmodifiableList(this.projectionOnFields);
    }

    @Override
    public <T extends Query> T addFilterQuery(FilterQuery filterQuery) {
        this.filterQueries.add(filterQuery);
        return (T)this;
    }

    @Override
    public <T extends Query> T setTimeAllowed(Integer timeAllowed) {
        this.timeAllowed = timeAllowed;
        return (T)this;
    }

    @Override
    public Integer getTimeAllowed() {
        return this.timeAllowed;
    }

    @Override
    public List<FilterQuery> getFilterQueries() {
        return Collections.unmodifiableList(this.filterQueries);
    }

    @Override
    public Query.Operator getDefaultOperator() {
        return this.defaultOperator != null ? this.defaultOperator : Query.Operator.NONE;
    }

    public boolean hasDefaultOperatorDefined() {
        return !Query.Operator.NONE.equals((Object)this.getDefaultOperator());
    }

    @Override
    public void setDefaultOperator(Query.Operator operator) {
        this.defaultOperator = operator;
    }

    @Override
    public String getDefType() {
        return this.defType != null ? this.defType : "";
    }

    @Override
    public void setDefType(String defType) {
        this.defType = defType;
    }
}

