/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.data.solr.core.query.result.FacetEntry;
import org.springframework.data.solr.core.query.result.FacetFieldEntry;
import org.springframework.data.solr.core.query.result.FacetPage;
import org.springframework.data.solr.core.query.result.FacetQueryEntry;
import org.springframework.data.solr.core.query.result.HighlightEntry;
import org.springframework.data.solr.core.query.result.HighlightPage;
import org.springframework.data.solr.core.query.result.PageKey;
import org.springframework.data.solr.core.query.result.StringPageKey;
import org.springframework.util.ObjectUtils;

public class SolrResultPage<T>
extends PageImpl<T>
implements FacetPage<T>,
HighlightPage<T> {
    private static final long serialVersionUID = -4199560685036530258L;
    private Map<PageKey, Page<FacetFieldEntry>> facetResultPages = new LinkedHashMap<PageKey, Page<FacetFieldEntry>>(1);
    private Page<FacetQueryEntry> facetQueryResult;
    private List<HighlightEntry<T>> highlighted;

    public SolrResultPage(List<T> content) {
        super(content);
    }

    public SolrResultPage(List<T> content, Pageable pageable, long total) {
        super(content, pageable, total);
    }

    @Override
    public final Page<FacetFieldEntry> getFacetResultPage(String fieldname) {
        PageImpl page = this.facetResultPages.get(new StringPageKey(fieldname));
        return page != null ? page : new PageImpl(Collections.emptyList());
    }

    @Override
    public final Page<FacetFieldEntry> getFacetResultPage(Field field) {
        return this.getFacetResultPage(field.getName());
    }

    public final void addFacetResultPage(Page<FacetFieldEntry> page, Field field) {
        this.facetResultPages.put(new StringPageKey(field.getName()), page);
    }

    public void addAllFacetFieldResultPages(Map<Field, Page<FacetFieldEntry>> pageMap) {
        for (Map.Entry<Field, Page<FacetFieldEntry>> entry : pageMap.entrySet()) {
            this.addFacetResultPage(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public Collection<Page<FacetFieldEntry>> getFacetResultPages() {
        return Collections.unmodifiableCollection(this.facetResultPages.values());
    }

    public final void setFacetQueryResultPage(List<FacetQueryEntry> facetQueryResult) {
        this.facetQueryResult = new PageImpl(facetQueryResult);
    }

    @Override
    public Page<FacetQueryEntry> getFacetQueryResult() {
        return this.facetQueryResult != null ? this.facetQueryResult : new PageImpl(Collections.emptyList());
    }

    @Override
    public Collection<Field> getFacetFields() {
        if (this.facetResultPages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Field> fields = new ArrayList<Field>(this.facetResultPages.size());
        for (PageKey pageKey : this.facetResultPages.keySet()) {
            fields.add(new SimpleField(pageKey.getKey().toString()));
        }
        return fields;
    }

    @Override
    public Collection<Page<? extends FacetEntry>> getAllFacets() {
        ArrayList<Page<? extends FacetEntry>> entries = new ArrayList<Page<? extends FacetEntry>>(this.facetResultPages.size() + 1);
        entries.addAll(this.facetResultPages.values());
        entries.add(this.facetQueryResult);
        return entries;
    }

    @Override
    public List<HighlightEntry<T>> getHighlighted() {
        return this.highlighted != null ? this.highlighted : Collections.emptyList();
    }

    public void setHighlighted(List<HighlightEntry<T>> highlighted) {
        this.highlighted = highlighted;
    }

    @Override
    public List<HighlightEntry.Highlight> getHighlights(T entity) {
        if (entity != null && this.highlighted != null) {
            for (HighlightEntry<T> highlightEntry : this.highlighted) {
                if (highlightEntry == null || !ObjectUtils.nullSafeEquals(highlightEntry.getEntity(), entity)) continue;
                return highlightEntry.getHighlights();
            }
        }
        return Collections.emptyList();
    }
}

