/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ProcessBean;
import org.springframework.data.repository.cdi.CdiRepositoryExtensionSupport;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.repository.cdi.SolrRepositoryBean;

public class SolrRepositoryExtension
extends CdiRepositoryExtensionSupport {
    private final Map<String, Bean<SolrOperations>> solrOperationsMap = new HashMap<String, Bean<SolrOperations>>();

    <T> void processBean(@Observes ProcessBean<T> processBean) {
        Bean bean = processBean.getBean();
        for (Type type : bean.getTypes()) {
            if (!(type instanceof Class) || !SolrOperations.class.isAssignableFrom((Class)type)) continue;
            this.solrOperationsMap.put(bean.getQualifiers().toString(), (Bean<SolrOperations>)bean);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (Map.Entry entry : this.getRepositoryTypes()) {
            Class repositoryType = (Class)entry.getKey();
            Set qualifiers = (Set)entry.getValue();
            Bean repositoryBean = this.createRepositoryBean(repositoryType, qualifiers, beanManager);
            afterBeanDiscovery.addBean(repositoryBean);
        }
    }

    private <T> Bean<T> createRepositoryBean(Class<T> repositoryType, Set<Annotation> qualifiers, BeanManager beanManager) {
        Bean<SolrOperations> solrOperationBeans = this.solrOperationsMap.get(qualifiers.toString());
        if (solrOperationBeans == null) {
            throw new UnsatisfiedResolutionException(String.format("Unable to resolve a bean for '%s' with qualifiers %s.", SolrOperations.class.getName(), qualifiers));
        }
        return new SolrRepositoryBean<T>(solrOperationBeans, qualifiers, repositoryType, beanManager);
    }
}

