/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.solr.repository.support.SolrRepositoryFactoryBean;
import org.w3c.dom.Element;

public class SolrRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    public String getRepositoryFactoryClassName() {
        return SolrRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return "solr";
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("solrOperations", attributes.getString("solrTemplateRef"));
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        builder.addPropertyReference("solrOperations", element.getAttribute("solr-template-ref"));
    }
}

