/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.repository.query.PartTreeSolrQuery;
import org.springframework.data.solr.repository.query.SolrEntityInformation;
import org.springframework.data.solr.repository.query.SolrEntityInformationCreator;
import org.springframework.data.solr.repository.query.SolrQueryMethod;
import org.springframework.data.solr.repository.query.StringBasedSolrQuery;
import org.springframework.data.solr.repository.support.SimpleSolrRepository;
import org.springframework.data.solr.repository.support.SolrEntityInformationCreatorImpl;
import org.springframework.util.Assert;

public class SolrRepositoryFactory
extends RepositoryFactorySupport {
    private final SolrOperations solrOperations;
    private final SolrEntityInformationCreator entityInformationCreator;

    public SolrRepositoryFactory(SolrOperations solrOperations) {
        Assert.notNull((Object)solrOperations);
        this.solrOperations = solrOperations;
        this.entityInformationCreator = new SolrEntityInformationCreatorImpl(solrOperations.getConverter().getMappingContext());
    }

    public <T, ID extends Serializable> SolrEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return this.entityInformationCreator.getEntityInformation(domainClass);
    }

    protected Object getTargetRepository(RepositoryMetadata metadata) {
        SimpleSolrRepository repository = new SimpleSolrRepository(this.getEntityInformation(metadata.getDomainType()), this.solrOperations);
        repository.setEntityClass(metadata.getDomainType());
        return repository;
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        if (SolrRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface())) {
            throw new IllegalArgumentException("QueryDsl Support has not been implemented yet.");
        }
        return SimpleSolrRepository.class;
    }

    private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QueryDslUtils.QUERY_DSL_PRESENT && QueryDslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
        return new SolrQueryLookupStrategy();
    }

    private class SolrQueryLookupStrategy
    implements QueryLookupStrategy {
        private SolrQueryLookupStrategy() {
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, NamedQueries namedQueries) {
            SolrQueryMethod queryMethod = new SolrQueryMethod(method, metadata, SolrRepositoryFactory.this.entityInformationCreator);
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new StringBasedSolrQuery(namedQuery, queryMethod, SolrRepositoryFactory.this.solrOperations);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedSolrQuery(queryMethod, SolrRepositoryFactory.this.solrOperations);
            }
            return new PartTreeSolrQuery(queryMethod, SolrRepositoryFactory.this.solrOperations);
        }
    }
}

