/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.solr.core.query.QueryParameter;
import org.springframework.util.Assert;

class ParameterHolder<T extends QueryParameter>
implements Iterable<T> {
    private final Map<String, T> parameters = new LinkedHashMap<String, T>(1);

    ParameterHolder() {
    }

    public <S> S getParameterValue(String parameterName) {
        QueryParameter parameter = (QueryParameter)this.parameters.get(parameterName);
        if (parameter == null) {
            return null;
        }
        return (S)parameter.getValue();
    }

    public void add(T queryParameter) {
        Assert.notNull(queryParameter);
        this.parameters.put(queryParameter.getName(), queryParameter);
    }

    public T get(String parameterName) {
        return (T)((QueryParameter)this.parameters.get(parameterName));
    }

    public T remove(String parameterName) {
        return (T)((QueryParameter)this.parameters.remove(parameterName));
    }

    public Collection<T> getParameters() {
        return Collections.unmodifiableCollection(this.parameters.values());
    }

    @Override
    public Iterator<T> iterator() {
        return this.parameters.values().iterator();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }
}

