/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.support;

import java.io.Serializable;
import org.apache.solr.client.solrj.SolrServer;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.TransactionalRepositoryFactoryBeanSupport;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.mapping.SimpleSolrMappingContext;
import org.springframework.data.solr.repository.support.SolrRepositoryFactory;
import org.springframework.util.Assert;

public class SolrRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends TransactionalRepositoryFactoryBeanSupport<T, S, ID> {
    private SolrServer solrServer;
    private SolrOperations operations;
    private boolean schemaCreationSupport;
    private SimpleSolrMappingContext solrMappingContext;

    public void setSolrOperations(SolrOperations operations) {
        this.operations = operations;
    }

    public void setSolrServer(SolrServer solrServer) {
        this.solrServer = solrServer;
    }

    public void setSchemaCreationSupport(boolean schemaCreationSupport) {
        this.schemaCreationSupport = schemaCreationSupport;
    }

    public void setSolrMappingContext(SimpleSolrMappingContext solrMappingContext) {
        this.solrMappingContext = solrMappingContext;
        super.setMappingContext((MappingContext)solrMappingContext);
    }

    public SimpleSolrMappingContext getSolrMappingContext() {
        return this.solrMappingContext;
    }

    protected SolrOperations getSolrOperations() {
        return this.operations;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.isTrue((this.operations != null || this.solrServer != null ? 1 : 0) != 0, (String)"SolrOperations or SolrServer must be configured!");
    }

    protected RepositoryFactorySupport doCreateRepositoryFactory() {
        SolrRepositoryFactory factory = this.operations != null ? new SolrRepositoryFactory(this.operations) : new SolrRepositoryFactory(this.solrServer);
        factory.setSchemaCreationSupport(this.schemaCreationSupport);
        return factory;
    }
}

