/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Arrays;
import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.Function;
import org.springframework.util.Assert;

public class DivideFunction
extends AbstractFunction {
    private static final String OPERATION = "div";

    private DivideFunction(Object dividend, Object divisor) {
        super(Arrays.asList(dividend, divisor));
    }

    public static Builder divide(Field field) {
        Assert.notNull((Object)field, (String)"Field cannot be 'null' for divide function.");
        return DivideFunction.divide(field.getName());
    }

    public static Builder divide(String fieldname) {
        Assert.hasText((String)fieldname, (String)"Fieldname cannot be 'empty' for divide function.");
        return new Builder(fieldname);
    }

    public static Builder divide(Number dividend) {
        return new Builder(dividend);
    }

    public static Builder divide(Function dividend) {
        return new Builder(dividend);
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }

    public static class Builder {
        private Object dividend;

        public Builder(Object dividend) {
            Assert.notNull((Object)dividend, (String)"Dividend must not be 'null'");
            this.dividend = dividend;
        }

        public DivideFunction by(Number divisor) {
            return this.by((Object)divisor);
        }

        public DivideFunction by(Function divisor) {
            return this.by((Object)divisor);
        }

        public DivideFunction by(String fieldname) {
            Assert.hasText((String)fieldname, (String)"Fieldname for devide function must not be 'empty'.");
            return this.by((Object)fieldname);
        }

        public DivideFunction by(Field field) {
            Assert.notNull((Object)field, (String)"Field must not be 'null'.");
            return this.by(field.getName());
        }

        private DivideFunction by(Object divisor) {
            Assert.notNull((Object)divisor, (String)"Cannot divide by 'null'.");
            return new DivideFunction(this.dividend, divisor);
        }
    }
}

