/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.solr.VersionUtil;
import org.springframework.data.solr.core.mapping.SolrDocument;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SolrClientUtils {
    private static final Logger logger = LoggerFactory.getLogger(SolrClientUtils.class);
    private static final String SLASH = "/";

    private SolrClientUtils() {
    }

    public static String resolveSolrCoreName(Class<?> type) {
        SolrDocument annotation = (SolrDocument)AnnotationUtils.findAnnotation(type, SolrDocument.class);
        if (annotation != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)annotation.solrCoreName())) {
            return annotation.solrCoreName();
        }
        return "";
    }

    public static <T extends SolrClient> T clone(T solrClient) {
        return SolrClientUtils.clone(solrClient, null);
    }

    public static <T extends SolrClient> T clone(T solrClient, String core) {
        Assert.notNull(solrClient, (String)"SolrClient must not be null!");
        String shortName = SolrClientUtils.getSolrClientTypeName(solrClient);
        if (shortName.equals("SolrClient")) {
            return solrClient;
        }
        SolrClient clone = null;
        if (shortName.equals("HttpSolrClient")) {
            clone = SolrClientUtils.cloneHttpSolrClient(solrClient, core);
        } else if (shortName.equals("LBHttpSolrClient")) {
            clone = SolrClientUtils.cloneLBHttpSolrClient(solrClient, core);
        } else if (shortName.equals("CloudSolrClient")) {
            clone = SolrClientUtils.cloneCloudSolrClient(solrClient, core);
        } else if (shortName.equals("EmbeddedSolrServer")) {
            clone = SolrClientUtils.cloneEmbeddedSolrServer(solrClient, core);
        }
        if (clone == null) {
            throw new BeanInstantiationException(solrClient.getClass(), "Cannot create instace of " + shortName + ".");
        }
        SolrClientUtils.copyProperties(solrClient, clone);
        return (T)clone;
    }

    public static String appendCoreToBaseUrl(String baseUrl, String core) {
        Assert.notNull((Object)baseUrl, (String)"Solr baseUrl must not be null!");
        if (!StringUtils.hasText((String)core)) {
            return baseUrl;
        }
        String url = baseUrl;
        if (!org.apache.commons.lang3.StringUtils.endsWith((CharSequence)baseUrl, (CharSequence)SLASH)) {
            url = url + SLASH;
        }
        url = url + core;
        return url;
    }

    private static String getSolrClientTypeName(SolrClient solrClient) {
        Class<?> solrClientType = ClassUtils.isCglibProxy((Object)solrClient) ? ClassUtils.getUserClass((Object)solrClient) : solrClient.getClass();
        String shortName = ClassUtils.getShortName(solrClientType);
        return shortName;
    }

    private static SolrClient cloneEmbeddedSolrServer(SolrClient solrClient, String core) {
        CoreContainer coreContainer = ((EmbeddedSolrServer)solrClient).getCoreContainer();
        try {
            Constructor constructor = ClassUtils.getConstructorIfAvailable(solrClient.getClass(), (Class[])new Class[]{CoreContainer.class, String.class});
            return (SolrClient)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{coreContainer, core});
        }
        catch (Exception e) {
            throw new BeanInstantiationException(solrClient.getClass(), "Cannot create instace of " + solrClient.getClass() + ".", (Throwable)e);
        }
    }

    private static SolrClient cloneHttpSolrClient(SolrClient solrClient, String core) {
        if (solrClient == null) {
            return null;
        }
        Method baseUrlGetterMethod = ClassUtils.getMethodIfAvailable(solrClient.getClass(), (String)"getBaseURL", (Class[])new Class[0]);
        if (baseUrlGetterMethod == null) {
            return null;
        }
        String baseUrl = (String)ReflectionUtils.invokeMethod((Method)baseUrlGetterMethod, (Object)solrClient);
        String url = SolrClientUtils.appendCoreToBaseUrl(baseUrl, core);
        try {
            Constructor constructor;
            HttpClient clientToUse = SolrClientUtils.readAndCloneHttpClient(solrClient);
            if (clientToUse != null && (constructor = ClassUtils.getConstructorIfAvailable(solrClient.getClass(), (Class[])new Class[]{String.class, HttpClient.class})) != null) {
                return (SolrClient)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{url, clientToUse});
            }
            constructor = ClassUtils.getConstructorIfAvailable(solrClient.getClass(), (Class[])new Class[]{String.class});
            return (SolrClient)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{url});
        }
        catch (Exception e) {
            throw new BeanInstantiationException(solrClient.getClass(), "Cannot create instace of " + solrClient.getClass() + ". ", (Throwable)e);
        }
    }

    private static LBHttpSolrClient cloneLBHttpSolrClient(SolrClient solrClient, String core) {
        if (solrClient == null) {
            return null;
        }
        LBHttpSolrClient clone = null;
        try {
            if (VersionUtil.isSolr3XAvailable()) {
                clone = SolrClientUtils.cloneSolr3LBHttpServer(solrClient, core);
            } else if (VersionUtil.isSolr4XAvailable()) {
                clone = SolrClientUtils.cloneSolr4LBHttpServer(solrClient, core);
            }
        }
        catch (Exception e) {
            throw new BeanInstantiationException(solrClient.getClass(), "Cannot create instace of " + solrClient.getClass() + ". ", (Throwable)e);
        }
        Object o = SolrClientUtils.readField(solrClient, "interval");
        if (o != null) {
            clone.setAliveCheckInterval(Integer.valueOf(o.toString()).intValue());
        }
        return clone;
    }

    private static SolrClient cloneCloudSolrClient(SolrClient solrClient, String core) {
        if (VersionUtil.isSolr3XAvailable() || solrClient == null) {
            return null;
        }
        CloudSolrClient cloudServer = (CloudSolrClient)solrClient;
        String zkHost = (String)SolrClientUtils.readField(solrClient, "zkHost");
        Constructor constructor = ClassUtils.getConstructorIfAvailable(solrClient.getClass(), (Class[])new Class[]{String.class, LBHttpSolrClient.class});
        CloudSolrClient clone = (CloudSolrClient)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{zkHost, SolrClientUtils.cloneLBHttpSolrClient((SolrClient)cloudServer.getLbClient(), core)});
        if (StringUtils.hasText((String)core)) {
            clone.setDefaultCollection(core);
        }
        return clone;
    }

    private static LBHttpSolrClient cloneSolr3LBHttpServer(SolrClient solrClient, String core) throws MalformedURLException {
        CopyOnWriteArrayList list = (CopyOnWriteArrayList)SolrClientUtils.readField(solrClient, "aliveServers");
        String[] servers = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            servers[i] = SolrClientUtils.appendCoreToBaseUrl(list.get(i).toString(), core);
        }
        return new LBHttpSolrClient(servers);
    }

    private static LBHttpSolrClient cloneSolr4LBHttpServer(SolrClient solrClient, String core) throws MalformedURLException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Map map = (Map)SolrClientUtils.readField(solrClient, "aliveServers");
        String[] servers = new String[map.size()];
        int i = 0;
        for (String key : map.keySet()) {
            servers[i] = SolrClientUtils.appendCoreToBaseUrl(key, core);
            ++i;
        }
        Boolean isInternalCient = (Boolean)SolrClientUtils.readField(solrClient, "clientIsInternal");
        if (isInternalCient != null && !isInternalCient.booleanValue()) {
            HttpClient clientToUse = SolrClientUtils.readAndCloneHttpClient(solrClient);
            return new LBHttpSolrClient(clientToUse, servers);
        }
        return new LBHttpSolrClient(servers);
    }

    private static HttpClient readAndCloneHttpClient(SolrClient solrClient) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        HttpClient sourceClient = (HttpClient)SolrClientUtils.readField(solrClient, "httpClient");
        return SolrClientUtils.cloneHttpClient(sourceClient);
    }

    private static HttpClient cloneHttpClient(HttpClient sourceClient) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (sourceClient == null) {
            return null;
        }
        Class clientType = ClassUtils.getUserClass((Object)sourceClient);
        Constructor constructor = ClassUtils.getConstructorIfAvailable((Class)clientType, (Class[])new Class[]{ClientConnectionManager.class, HttpParams.class});
        if (constructor != null) {
            HttpClient targetClient = (HttpClient)constructor.newInstance(sourceClient.getConnectionManager(), sourceClient.getParams());
            BeanUtils.copyProperties((Object)sourceClient, (Object)targetClient);
            return targetClient;
        }
        constructor = ClassUtils.getConstructorIfAvailable((Class)clientType, (Class[])new Class[]{HttpParams.class});
        if (constructor != null) {
            HttpClient targetClient = (HttpClient)constructor.newInstance(sourceClient.getParams());
            BeanUtils.copyProperties((Object)sourceClient, (Object)targetClient);
            return targetClient;
        }
        return new DefaultHttpClient(sourceClient.getParams());
    }

    private static <T> T readField(SolrClient solrServer, String fieldName) {
        Field field = ReflectionUtils.findField(solrServer.getClass(), (String)fieldName);
        if (field == null) {
            return null;
        }
        ReflectionUtils.makeAccessible((Field)field);
        return (T)ReflectionUtils.getField((Field)field, (Object)solrServer);
    }

    private static void copyProperties(SolrClient source, SolrClient target) {
        BeanWrapperImpl wrapperImpl = new BeanWrapperImpl((Object)source);
        for (PropertyDescriptor pd : wrapperImpl.getPropertyDescriptors()) {
            Method writer = pd.getWriteMethod();
            if (writer == null) continue;
            try {
                Field property = ReflectionUtils.findField(source.getClass(), (String)pd.getName());
                if (property == null) continue;
                ReflectionUtils.makeAccessible((Field)property);
                Object o = ReflectionUtils.getField((Field)property, (Object)source);
                if (o == null) continue;
                writer.invoke((Object)target, o);
            }
            catch (Exception e) {
                logger.warn("Could not copy property value for: " + pd.getName(), (Throwable)e);
            }
        }
    }
}

