/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.query;

import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.repository.query.AbstractSolrQuery;
import org.springframework.data.solr.repository.query.SolrParameterAccessor;
import org.springframework.data.solr.repository.query.SolrQueryCreator;
import org.springframework.data.solr.repository.query.SolrQueryMethod;

public class PartTreeSolrQuery
extends AbstractSolrQuery {
    private final PartTree tree;
    private final MappingContext<?, SolrPersistentProperty> mappingContext;

    public PartTreeSolrQuery(SolrQueryMethod method, SolrOperations solrOperations) {
        super(solrOperations, method);
        this.tree = new PartTree(method.getName(), method.getEntityInformation().getJavaType());
        this.mappingContext = solrOperations.getConverter().getMappingContext();
    }

    public PartTree getTree() {
        return this.tree;
    }

    @Override
    protected Query createQuery(SolrParameterAccessor parameterAccessor) {
        Query query = (Query)new SolrQueryCreator(this.tree, parameterAccessor, this.mappingContext).createQuery();
        this.appendProjection(query);
        return query;
    }

    @Override
    public boolean isCountQuery() {
        return this.tree.isCountProjection();
    }

    @Override
    public boolean isDeleteQuery() {
        return this.tree.isDelete();
    }

    @Override
    public boolean isLimiting() {
        return this.tree.isLimiting();
    }

    @Override
    public int getLimit() {
        if (this.isLimiting()) {
            return this.tree.getMaxResults();
        }
        return super.getLimit();
    }
}

