/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class SolrPageRequest
implements Pageable {
    private Sort sort;
    private int page;
    private int size;

    public SolrPageRequest(int page, int size) {
        this(page, size, null);
    }

    public SolrPageRequest(int page, int size, Sort.Direction direction, String ... properties) {
        this(page, size, new Sort(direction, properties));
    }

    public SolrPageRequest(int page, int size, Sort sort) {
        this.page = page;
        this.size = size;
        this.sort = sort;
    }

    public int getPageNumber() {
        return this.page;
    }

    public int getPageSize() {
        return this.size;
    }

    public int getOffset() {
        return this.page * this.size;
    }

    public Sort getSort() {
        return this.sort;
    }

    public Pageable next() {
        return new SolrPageRequest(this.getPageNumber() + 1, this.getPageSize(), this.getSort());
    }

    public Pageable previousOrFirst() {
        return this.hasPrevious() ? this.previous() : this.first();
    }

    public Pageable first() {
        return new SolrPageRequest(0, this.getPageSize(), this.getSort());
    }

    public boolean hasPrevious() {
        return this.page > 0;
    }

    public Pageable previous() {
        return this.getPageNumber() == 0 ? this : new SolrPageRequest(this.getPageNumber() - 1, this.getPageSize(), this.getSort());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.page;
        result = 31 * result + this.size;
        result = 31 * result + (this.sort == null ? 0 : this.sort.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Pageable)) {
            return false;
        }
        Pageable other = (Pageable)obj;
        if (this.page != other.getPageNumber()) {
            return false;
        }
        if (this.size != other.getPageSize()) {
            return false;
        }
        return !(this.sort == null ? other.getSort() != null : !this.sort.equals((Object)other.getSort()));
    }

    public String toString() {
        return "SolrPageRequest [number=" + this.page + ", size=" + this.size + ", sort=" + this.sort + "]";
    }
}

