/*
 * Copyright 2012 - 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.solr.core.query.result;

import java.util.List;

import org.springframework.data.domain.Page;

/**
 * @author Christoph Strobl
 */
public interface TermsPage extends Iterable<TermsFieldEntry> {

	/**
	 * Returns the page content as {@link List}.
	 * 
	 * @return
	 */
	Iterable<TermsFieldEntry> getContent();

	/**
	 * @param fieldname
	 * @return
	 */
	Iterable<TermsFieldEntry> getTermsForField(String fieldname);

	/**
	 * Returns whether the {@link Page} has content at all.
	 * 
	 * @return
	 */
	boolean hasContent();

}
