/*
 * Copyright 2012-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.solr.core.mapping;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.apache.solr.common.params.SolrParams;
import org.springframework.core.annotation.AliasFor;
import org.springframework.data.annotation.Persistent;

/**
 * @author Christoph Strobl
 */
@Persistent
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.TYPE })
public @interface SolrDocument {

	/**
	 * Defines the {@literal collectionname} the document is persisted in.
	 * 
	 * @return
	 * @deprecated since 3.0. Please use {@link #collection()}.
	 */
	@Deprecated
	@AliasFor(attribute = "collection")
	String solrCoreName() default "";

	/**
	 * Index time boost value for document.
	 * 
	 * @return
	 * @since 1.2
	 */
	float boost() default Float.NaN;

	/**
	 * @return
	 * @since 3.0
	 */
	@AliasFor(attribute = "solrCoreName")
	String collection() default "";

}
