/*
 * Copyright 2012 - 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.solr.core.query;

import org.springframework.data.domain.Pageable;
import org.springframework.lang.Nullable;

/**
 * Trivial implementation of {@link HighlightQuery} extending {@link SimpleQuery}.
 * 
 * @author Christoph Strobl
 */
public class SimpleHighlightQuery extends SimpleQuery implements HighlightQuery {

	private @Nullable HighlightOptions highlightOptions;

	public SimpleHighlightQuery() {
		super();
	}

	public SimpleHighlightQuery(Criteria criteria, @Nullable Pageable pageable) {
		super(criteria, pageable);
	}

	public SimpleHighlightQuery(Criteria criteria) {
		super(criteria);
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T extends SolrDataQuery> T setHighlightOptions(HighlightOptions highlightOptions) {
		this.highlightOptions = highlightOptions;
		return (T) this;
	}

	@Nullable
	@Override
	public HighlightOptions getHighlightOptions() {
		return this.highlightOptions;
	}

	@Override
	public boolean hasHighlightOptions() {
		return this.highlightOptions != null;
	}

}
