/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.config;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.solr.core.SolrExceptionTranslator;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.SolrTemplate;
import org.springframework.data.solr.core.convert.MappingSolrConverter;
import org.springframework.data.solr.core.convert.SolrCustomConversions;
import org.springframework.data.solr.core.mapping.SimpleSolrMappingContext;
import org.springframework.data.solr.core.mapping.SolrDocument;
import org.springframework.data.solr.repository.SolrCrudRepository;
import org.springframework.data.solr.repository.SolrRepository;
import org.springframework.data.solr.repository.support.SolrRepositoryFactoryBean;
import org.springframework.data.solr.server.support.HttpSolrClientFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class SolrRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    public String getRepositoryFactoryBeanClassName() {
        return SolrRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return "solr";
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference(BeanDefinitionName.SOLR_OPERATIONS.getBeanName(), attributes.getString("solrTemplateRef"));
        builder.addPropertyValue("schemaCreationSupport", (Object)attributes.getBoolean("schemaCreationSupport"));
        builder.addPropertyReference(BeanDefinitionName.SOLR_MAPPTING_CONTEXT.getBeanName(), "solrMappingContext");
        builder.addPropertyReference(BeanDefinitionName.SOLR_CONVERTER.getBeanName(), "solrConverter");
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        super.registerBeansForRoot(registry, configurationSource);
        this.registeCustomConversionsIfNotPresent(registry, configurationSource);
        this.registerSolrMappingContextIfNotPresent(registry, configurationSource);
        this.registerSolrConverterIfNotPresent(registry, configurationSource);
        this.registerSolrTemplateIfNotPresent(registry, configurationSource);
        SolrRepositoryConfigExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(SolrExceptionTranslator.class).getBeanDefinition(), (BeanDefinitionRegistry)registry, (String)"solrExceptionTranslator", (Object)configurationSource);
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        builder.addPropertyReference(BeanDefinitionName.SOLR_OPERATIONS.getBeanName(), element.getAttribute("solr-template-ref"));
        if (StringUtils.hasText((String)element.getAttribute("schema-creation-support"))) {
            builder.addPropertyValue("schemaCreationSupport", (Object)element.getAttribute("schema-creation-support"));
        }
        builder.addPropertyReference(BeanDefinitionName.SOLR_MAPPTING_CONTEXT.getBeanName(), "solrMappingContext");
        builder.addPropertyReference(BeanDefinitionName.SOLR_CONVERTER.getBeanName(), "solrConverter");
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(SolrDocument.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Arrays.asList(SolrRepository.class, SolrCrudRepository.class);
    }

    private void registeCustomConversionsIfNotPresent(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        RootBeanDefinition definition = new RootBeanDefinition(SolrCustomConversions.class);
        definition.getConstructorArgumentValues().addGenericArgumentValue(Collections.emptyList());
        definition.setRole(2);
        definition.setSource(configurationSource.getSource());
        SolrRepositoryConfigExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)definition, (BeanDefinitionRegistry)registry, (String)BeanDefinitionName.CUSTOM_CONVERSIONS.getBeanName(), (Object)definition);
    }

    private void registerSolrMappingContextIfNotPresent(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        RootBeanDefinition definition = new RootBeanDefinition(SimpleSolrMappingContext.class);
        definition.setRole(2);
        definition.setSource(configurationSource.getSource());
        SolrRepositoryConfigExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)definition, (BeanDefinitionRegistry)registry, (String)BeanDefinitionName.SOLR_MAPPTING_CONTEXT.getBeanName(), (Object)definition);
    }

    private void registerSolrConverterIfNotPresent(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        RootBeanDefinition definition = new RootBeanDefinition(MappingSolrConverter.class);
        ConstructorArgumentValues ctorArgs = new ConstructorArgumentValues();
        ctorArgs.addIndexedArgumentValue(0, (Object)new RuntimeBeanReference(BeanDefinitionName.SOLR_MAPPTING_CONTEXT.getBeanName()));
        definition.setConstructorArgumentValues(ctorArgs);
        MutablePropertyValues properties = new MutablePropertyValues();
        properties.add("customConversions", (Object)new RuntimeBeanReference(BeanDefinitionName.CUSTOM_CONVERSIONS.getBeanName()));
        definition.setPropertyValues(properties);
        definition.setRole(2);
        definition.setSource(configurationSource.getSource());
        SolrRepositoryConfigExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)definition, (BeanDefinitionRegistry)registry, (String)BeanDefinitionName.SOLR_CONVERTER.getBeanName(), (Object)definition);
    }

    private void registerSolrTemplateIfNotPresent(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        RootBeanDefinition solrTemplateDefinition = new RootBeanDefinition(SolrTemplate.class);
        solrTemplateDefinition.setTargetType(SolrOperations.class);
        ConstructorArgumentValues ctorArgs = new ConstructorArgumentValues();
        ctorArgs.addIndexedArgumentValue(0, (Object)this.createHttpSolrClientFactory());
        ctorArgs.addIndexedArgumentValue(1, (Object)new RuntimeBeanReference(BeanDefinitionName.SOLR_CONVERTER.getBeanName()));
        solrTemplateDefinition.setConstructorArgumentValues(ctorArgs);
        SolrRepositoryConfigExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)solrTemplateDefinition, (BeanDefinitionRegistry)registry, (String)"solrTemplate", (Object)solrTemplateDefinition);
    }

    private BeanDefinition createHttpSolrClientFactory() {
        GenericBeanDefinition solrClientFactory = new GenericBeanDefinition();
        solrClientFactory.setBeanClass(HttpSolrClientFactory.class);
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        args.addIndexedArgumentValue(0, (Object)new RuntimeBeanReference(BeanDefinitionName.SOLR_CLIENT.getBeanName()));
        solrClientFactory.setConstructorArgumentValues(args);
        return solrClientFactory;
    }

    static enum BeanDefinitionName {
        SOLR_MAPPTING_CONTEXT("solrMappingContext"),
        SOLR_OPERATIONS("solrOperations"),
        SOLR_CLIENT("solrClient"),
        SOLR_CONVERTER("solrConverter"),
        CUSTOM_CONVERSIONS("customConversions");

        String beanName;

        private BeanDefinitionName(String beanName) {
            this.beanName = beanName;
        }

        public String getBeanName() {
            return this.beanName;
        }
    }
}

