/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.result.FieldStatsResult;
import org.springframework.data.solr.core.query.result.SimpleStatsResult;
import org.springframework.data.solr.core.query.result.StatsResult;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleFieldStatsResult
extends SimpleStatsResult
implements FieldStatsResult {
    private Map<String, Map<String, StatsResult>> facetStatsResult = Collections.emptyMap();
    @Nullable
    private Long distinctCount;
    private Collection<Object> distinctValues = Collections.emptyList();

    @Override
    public Map<String, Map<String, StatsResult>> getFacetStatsResults() {
        return Collections.unmodifiableMap(this.facetStatsResult);
    }

    public void setStatsResults(Map<String, Map<String, StatsResult>> statsResults) {
        this.facetStatsResult = statsResults;
    }

    @Override
    public Map<String, StatsResult> getFacetStatsResult(Field field) {
        Assert.notNull((Object)field, (String)"field must not be null");
        return this.getFacetStatsResult(field.getName());
    }

    @Override
    public Map<String, StatsResult> getFacetStatsResult(String fieldName) {
        Assert.notNull((Object)"fieldName must be not null", (String)fieldName);
        return this.facetStatsResult.get(fieldName);
    }

    @Override
    @Nullable
    public Long getDistinctCount() {
        return this.distinctCount;
    }

    public void setCountDistinct(Long distinctCount) {
        this.distinctCount = distinctCount;
    }

    @Override
    public Collection<Object> getDistinctValues() {
        return Collections.unmodifiableCollection(this.distinctValues);
    }

    public void setDistinctValues(@Nullable Collection<Object> distinctValues) {
        if (distinctValues == null) {
            this.distinctValues = Collections.emptyList();
        } else {
            this.distinctValues = new ArrayList<Object>();
            this.distinctValues.addAll(distinctValues);
        }
    }

    @Override
    public String toString() {
        return "SimpleFieldStatsResult [min=" + this.getMin() + ", max=" + this.getMax() + ", sum=" + this.getSum() + ", mean=" + this.getMean() + ", count=" + this.getCount() + ", missing=" + this.getMissing() + ", stddev=" + this.getStddev() + ", statsResults=" + this.facetStatsResult + "]";
    }
}

