/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.integration.config;

import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.yarn.config.YarnNamespaceUtils;
import org.w3c.dom.Element;

public class IntegrationConverterParser
extends AbstractBeanDefinitionParser {
    private final ManagedSet<Object> converters = new ManagedSet();
    private volatile boolean initialized;
    private final Object initializationMonitor = new Object();

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        this.initializeConversionServiceInfrastructureIfNecessary(parserContext);
        BeanComponentDefinition converterDefinition = YarnNamespaceUtils.parseInnerHandlerDefinition((Element)element, (ParserContext)parserContext);
        if (converterDefinition != null) {
            this.converters.add((Object)converterDefinition);
        } else {
            String beanName = element.getAttribute("ref");
            Assert.isTrue((boolean)StringUtils.hasText((String)beanName), (String)"Either a 'ref' attribute pointing to a Converter or a <bean> sub-element defining a Converter is required.");
            this.converters.add((Object)new RuntimeBeanReference(beanName));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeConversionServiceInfrastructureIfNecessary(ParserContext parserContext) {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (!this.initialized) {
                String contextPackage = "org.springframework.yarn.integration.convert.";
                BeanDefinitionBuilder creatorBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)(contextPackage + "ConversionServiceCreator"));
                BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)creatorBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
                BeanDefinitionBuilder conversionServiceBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)(contextPackage + "ConverterRegistrar"));
                conversionServiceBuilder.addConstructorArgValue(this.converters);
                BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)conversionServiceBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
                this.initialized = true;
            }
        }
    }
}

