/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.integration.ip.mind;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;
import org.springframework.yarn.integration.ip.mind.MindRpcMessageHolder;

public class MindRpcSerializer
implements Serializer<MindRpcMessageHolder>,
Deserializer<MindRpcMessageHolder> {
    private static final Log log = LogFactory.getLog(MindRpcSerializer.class);
    protected int maxMessageSize = 20000;

    public MindRpcMessageHolder deserialize(InputStream inputStream) throws IOException {
        int[] lenghts = this.readHeader(inputStream);
        if (log.isDebugEnabled()) {
            log.debug((Object)("rpc lenghts: " + lenghts[0] + "/" + lenghts[1]));
        }
        Map<String, String> headers = this.readHeaders(inputStream, lenghts[0]);
        byte[] content = this.readBytes(inputStream, lenghts[1]);
        if (log.isDebugEnabled()) {
            log.debug((Object)("deserialize: " + content));
        }
        return new MindRpcMessageHolder(headers, content);
    }

    public void serialize(MindRpcMessageHolder object, OutputStream outputStream) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("serialize length=" + object.toBytes().length + " :" + new String(object.toBytes())));
        }
        outputStream.write(object.toBytes());
        outputStream.flush();
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    protected int[] readHeader(InputStream inputStream) throws IOException {
        int n;
        byte[] buffer;
        int[] ret;
        block4: {
            ret = new int[]{0, 0};
            buffer = new byte[20];
            n = 0;
            do {
                int bite;
                if ((bite = inputStream.read()) < 0 && n == 0) {
                    throw new SoftEndOfStreamException("Stream closed between payloads");
                }
                this.checkClosure(bite);
                if (n > 0 && bite == 10 && buffer[n - 1] == 13) break block4;
                buffer[n++] = (byte)bite;
            } while (n < 20);
            throw new IOException("CRLF not found before max message length: " + this.maxMessageSize);
        }
        byte[] assembledData = new byte[n - 1];
        System.arraycopy(buffer, 0, assembledData, 0, n - 1);
        String header = new String(assembledData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mind rpc header:" + header));
        }
        String[] respBytes = header.split(" ");
        ret[0] = Integer.parseInt(respBytes[1]);
        ret[1] = Integer.parseInt(respBytes[2]);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mind rpc parsed sizes: head=" + ret[0] + " content=" + ret[1]));
        }
        return ret;
    }

    protected Map<String, String> readHeaders(InputStream inputStream, int length) throws IOException {
        String line;
        HashMap<String, String> map = new HashMap<String, String>();
        byte[] bytes = this.readBytes(inputStream, length);
        BufferedReader reader = new BufferedReader(new StringReader(new String(bytes)));
        while ((line = reader.readLine()) != null) {
            String[] split;
            if (log.isDebugEnabled()) {
                log.debug((Object)("deserialize header: " + line));
            }
            if (!((split = line.split(":")) != null & split.length == 2)) continue;
            map.put(split[0], split[1]);
        }
        return map;
    }

    protected byte[] readBytes(InputStream inputStream, int length) throws IOException {
        int len;
        byte[] buffer = new byte[length];
        for (int lengthRead = 0; lengthRead < length; lengthRead += len) {
            len = inputStream.read(buffer, lengthRead, length - lengthRead);
            if (len >= 0) continue;
            throw new IOException("Stream closed after " + lengthRead + " of " + length);
        }
        return buffer;
    }

    protected void checkClosure(int bite) throws IOException {
        if (bite < 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Socket closed during message assembly");
            }
            throw new IOException("Socket closed during message assembly");
        }
    }
}

