/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.integration.convert;

import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.util.Assert;
import org.springframework.yarn.integration.support.IntegrationContextUtils;

public class ConverterRegistrar
implements InitializingBean,
BeanFactoryAware {
    private final Set<Converter<?, ?>> converters;
    private BeanFactory beanFactory;

    public ConverterRegistrar(Set<Converter<?, ?>> converters) {
        this.converters = converters;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.beanFactory, (String)"BeanFactory is required");
        ConversionService conversionService = IntegrationContextUtils.getConversionService(this.beanFactory);
        if (conversionService instanceof GenericConversionService) {
            ConversionServiceFactory.registerConverters(this.converters, (ConverterRegistry)((GenericConversionService)conversionService));
        } else {
            Assert.notNull((Object)conversionService, (String)"Failed to locate 'integrationConversionService'");
        }
    }
}

