/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.integration.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.ip.tcp.TcpInboundGateway;
import org.springframework.integration.ip.tcp.connection.TcpNetServerConnectionFactory;
import org.springframework.util.StringUtils;
import org.springframework.yarn.config.YarnNamespaceUtils;
import org.springframework.yarn.integration.IntegrationAppmasterServiceFactoryBean;
import org.springframework.yarn.integration.ip.mind.MindRpcSerializer;
import org.springframework.yarn.integration.support.DefaultPortExposingTcpSocketSupport;
import org.w3c.dom.Element;

public class IntegrationAmServiceParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return IntegrationAppmasterServiceFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        boolean hasChannelAttribute = element.hasAttribute("channel");
        if (!hasChannelAttribute) {
            BeanDefinitionBuilder defBuilder = BeanDefinitionBuilder.genericBeanDefinition(DirectChannel.class);
            AbstractBeanDefinition beanDef = defBuilder.getBeanDefinition();
            String channelBeanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, channelBeanName));
            builder.addPropertyReference("channel", channelBeanName);
            defBuilder = BeanDefinitionBuilder.genericBeanDefinition(MindRpcSerializer.class);
            beanDef = defBuilder.getBeanDefinition();
            String serializerBeanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, serializerBeanName));
            defBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultPortExposingTcpSocketSupport.class);
            beanDef = defBuilder.getBeanDefinition();
            String socketSupportBeanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, socketSupportBeanName));
            builder.addPropertyReference("socketSupport", socketSupportBeanName);
            defBuilder = BeanDefinitionBuilder.genericBeanDefinition(TcpNetServerConnectionFactory.class);
            String port = element.hasAttribute("default-port") ? element.getAttribute("default-port") : "0";
            defBuilder.addConstructorArgValue((Object)port);
            defBuilder.addPropertyReference("tcpSocketSupport", socketSupportBeanName);
            defBuilder.addPropertyReference("serializer", serializerBeanName);
            defBuilder.addPropertyReference("deserializer", serializerBeanName);
            beanDef = defBuilder.getBeanDefinition();
            String connectionFactoryBeanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, connectionFactoryBeanName));
            defBuilder = BeanDefinitionBuilder.genericBeanDefinition(TcpInboundGateway.class);
            defBuilder.addPropertyReference("connectionFactory", connectionFactoryBeanName);
            defBuilder.addPropertyReference("requestChannel", channelBeanName);
            beanDef = defBuilder.getBeanDefinition();
            String gatewayBeanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDef, (BeanDefinitionRegistry)parserContext.getRegistry());
            parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)beanDef, gatewayBeanName));
            builder.addPropertyReference("channel", channelBeanName);
        } else {
            YarnNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"channel");
        }
        YarnNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"service-impl");
        YarnNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"service-ref");
        YarnNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"object-mapper");
        YarnNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"socket-support");
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String name = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)name)) {
            name = "yarnAmservice";
        }
        return name;
    }
}

