/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.integration.ip.mind;

import java.util.HashMap;
import java.util.Map;

public class MindRpcMessageHolder {
    private Map<String, String> headers;
    private byte[] content;

    public MindRpcMessageHolder(Map<String, String> headers, String content) {
        this.headers = headers != null ? headers : new HashMap();
        this.content = content.getBytes();
    }

    public MindRpcMessageHolder(Map<String, String> headers, byte[] content) {
        this.headers = headers != null ? headers : new HashMap();
        this.content = content;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void setContent(String content) {
        this.content = content.getBytes();
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public byte[] getContent() {
        return this.content;
    }

    public byte[] toBytes() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            buf.append(entry.getKey());
            buf.append(": ");
            buf.append(entry.getValue());
            buf.append("\r\n");
        }
        buf.append("\r\n");
        int l1 = buf.length();
        buf.insert(0, "MRPC/2 " + l1 + " " + this.content.length + "\r\n");
        byte[] bytes1 = buf.toString().getBytes();
        byte[] combined = new byte[this.content.length + bytes1.length];
        System.arraycopy(bytes1, 0, combined, 0, bytes1.length);
        System.arraycopy(this.content, 0, combined, bytes1.length, this.content.length);
        return combined;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Holder headers={");
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            buf.append(entry.getKey());
            buf.append("=");
            buf.append(entry.getValue());
            buf.append(",");
        }
        buf.append("} Content size=");
        buf.append(this.content != null ? this.content.length : 0);
        buf.append(", Content=");
        buf.append(this.content != null ? new String(this.content) : "");
        return buf.toString();
    }
}

