/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.server.exec;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.springframework.util.Assert;

class LoggingMavenRepositoryListener
extends AbstractRepositoryListener {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    LoggingMavenRepositoryListener() {
    }

    public void artifactDeployed(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deployed " + String.valueOf(event.getArtifact()) + " to " + String.valueOf(event.getRepository())));
        }
    }

    public void artifactDeploying(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deploying " + String.valueOf(event.getArtifact()) + " to " + String.valueOf(event.getRepository())));
        }
    }

    public void artifactDescriptorInvalid(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invalid artifact descriptor for " + String.valueOf(event.getArtifact()) + ": " + event.getException().getMessage()));
        }
    }

    public void artifactDescriptorMissing(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Missing artifact descriptor for " + String.valueOf(event.getArtifact())));
        }
    }

    public void artifactInstalled(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Installed " + String.valueOf(event.getArtifact()) + " to " + String.valueOf(event.getFile())));
        }
    }

    public void artifactInstalling(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Installing " + String.valueOf(event.getArtifact()) + " to " + String.valueOf(event.getFile())));
        }
    }

    public void artifactResolved(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolved artifact " + String.valueOf(event.getArtifact()) + " from " + String.valueOf(event.getRepository())));
        }
    }

    public void artifactDownloading(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Downloading artifact " + String.valueOf(event.getArtifact()) + " from " + String.valueOf(event.getRepository())));
        }
    }

    public void artifactDownloaded(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Downloaded artifact " + String.valueOf(event.getArtifact()) + " from " + String.valueOf(event.getRepository())));
        }
    }

    public void artifactResolving(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolving artifact " + String.valueOf(event.getArtifact())));
        }
    }

    public void metadataDeployed(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deployed " + String.valueOf(event.getMetadata()) + " to " + String.valueOf(event.getRepository())));
        }
    }

    public void metadataDeploying(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deploying " + String.valueOf(event.getMetadata()) + " to " + String.valueOf(event.getRepository())));
        }
    }

    public void metadataInstalled(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Installed " + String.valueOf(event.getMetadata()) + " to " + String.valueOf(event.getFile())));
        }
    }

    public void metadataInstalling(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Installing " + String.valueOf(event.getMetadata()) + " to " + String.valueOf(event.getFile())));
        }
    }

    public void metadataInvalid(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invalid metadata " + String.valueOf(event.getMetadata())));
        }
    }

    public void metadataResolved(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolved metadata " + String.valueOf(event.getMetadata()) + " from " + String.valueOf(event.getRepository())));
        }
    }

    public void metadataResolving(RepositoryEvent event) {
        LoggingMavenRepositoryListener.assertEventNotNull(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolving metadata " + String.valueOf(event.getMetadata()) + " from " + String.valueOf(event.getRepository())));
        }
    }

    private static void assertEventNotNull(RepositoryEvent event) {
        Assert.notNull((Object)event, (String)"event cannot be null");
    }
}

