/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.server.exec;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;

class LoggingMavenTransferListener
extends AbstractTransferListener {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Map<TransferResource, Long> downloads = new ConcurrentHashMap<TransferResource, Long>();
    private int lastLength;

    LoggingMavenTransferListener() {
    }

    public void transferInitiated(TransferEvent event) {
        String message;
        Objects.requireNonNull(event, "event cannot be null");
        String string = message = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(message + ": " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName()));
        }
    }

    public void transferProgressed(TransferEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        TransferResource resource = event.getResource();
        this.downloads.put(resource, event.getTransferredBytes());
        StringBuilder buffer = new StringBuilder(64);
        for (Map.Entry<TransferResource, Long> entry : this.downloads.entrySet()) {
            long total = entry.getKey().getContentLength();
            long complete = entry.getValue();
            buffer.append(this.getStatus(complete, total)).append("  ");
        }
        int pad = this.lastLength - buffer.length();
        this.lastLength = buffer.length();
        this.pad(buffer, pad);
        buffer.append('\r');
        this.logger.debug((Object)buffer);
    }

    private String getStatus(long complete, long total) {
        if (total >= 1024L) {
            return this.toKB(complete) + "/" + this.toKB(total) + " KB ";
        }
        if (total >= 0L) {
            return complete + "/" + total + " B ";
        }
        if (complete >= 1024L) {
            return this.toKB(complete) + " KB ";
        }
        return complete + " B ";
    }

    private void pad(StringBuilder buffer, int spaces) {
        String block = "                                        ";
        while (spaces > 0) {
            int n = Math.min(spaces, block.length());
            buffer.append(block, 0, n);
            spaces -= n;
        }
    }

    public void transferSucceeded(TransferEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        this.transferCompleted(event);
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        if (contentLength >= 0L) {
            String type = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
            String len = contentLength >= 1024L ? this.toKB(contentLength) + " KB" : contentLength + " B";
            Object throughput = "";
            long duration = System.currentTimeMillis() - resource.getTransferStartTime();
            if (duration > 0L) {
                long bytes = contentLength - resource.getResumeOffset();
                DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                double kbPerSec = (double)bytes / 1024.0 / ((double)duration / 1000.0);
                throughput = " at " + format.format(kbPerSec) + " KB/sec";
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(type + ": " + resource.getRepositoryUrl() + resource.getResourceName() + " (" + len + (String)throughput + ")"));
            }
        }
    }

    public void transferFailed(TransferEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        this.transferCompleted(event);
        if (!(event.getException() instanceof MetadataNotFoundException)) {
            this.logger.error((Object)"Transfer failed", (Throwable)event.getException());
        }
    }

    private void transferCompleted(TransferEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        this.downloads.remove(event.getResource());
        StringBuilder buffer = new StringBuilder(64);
        this.pad(buffer, this.lastLength);
        buffer.append('\r');
        this.logger.debug((Object)buffer);
    }

    public void transferCorrupted(TransferEvent event) {
        Objects.requireNonNull(event, "event cannot be null");
        this.logger.error((Object)"Transfer corrupted", (Throwable)event.getException());
    }

    protected long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }
}

