/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.server.exec;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.springframework.boot.SpringBootVersion;
import org.springframework.experimental.boot.server.exec.ClasspathEntry;
import org.springframework.experimental.boot.server.exec.LoggingMavenRepositoryListener;
import org.springframework.experimental.boot.server.exec.LoggingMavenTransferListener;

public class MavenClasspathEntry
implements ClasspathEntry {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final List<RemoteRepository> repositories;
    public final String coords;

    public MavenClasspathEntry(String coords) {
        this(coords, MavenClasspathEntry.newRepositories());
    }

    public MavenClasspathEntry(String coords, List<RemoteRepository> repositories) {
        this.coords = coords;
        this.repositories = repositories;
    }

    public static MavenClasspathEntry springBootStarter(String starterName) {
        return MavenClasspathEntry.springBootDependency("spring-boot-starter-" + starterName);
    }

    public static MavenClasspathEntry springBootDependency(String artifactName) {
        return new MavenClasspathEntry("org.springframework.boot:" + artifactName + ":" + SpringBootVersion.getVersion());
    }

    public List<String> resolve() {
        RepositorySystem system = MavenClasspathEntry.newRepositorySystem();
        DefaultRepositorySystemSession session = MavenClasspathEntry.newRepositorySystemSession(system);
        DefaultArtifact artifact = new DefaultArtifact(this.coords);
        DependencyFilter scopeFilter = DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime", "compile"});
        DependencyFilter optionalFilter = (node, parents) -> !node.getDependency().isOptional();
        AndDependencyFilter dependencyFilter = new AndDependencyFilter(new DependencyFilter[]{scopeFilter, optionalFilter});
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency((Artifact)artifact, "runtime"));
        collectRequest.setRepositories(this.repositories);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, (DependencyFilter)dependencyFilter);
        ArrayList<String> result = new ArrayList<String>();
        try {
            List artifactResults = system.resolveDependencies((RepositorySystemSession)session, dependencyRequest).getArtifactResults();
            for (ArtifactResult artifactResult : artifactResults) {
                result.add(artifactResult.getArtifact().getFile().getAbsolutePath());
            }
        }
        catch (Exception ex) {
            String message = "Error resolving artifact " + this.coords;
            this.logger.debug((Object)message, (Throwable)ex);
            throw new RuntimeException(message, ex);
        }
        return result;
    }

    private static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                exception.printStackTrace();
            }
        });
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private static DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        HashMap<Object, Object> sysProps = new HashMap<Object, Object>(System.getProperties());
        String homeDirectory = System.getProperty("user.home");
        File mavenLocal = new File(homeDirectory, ".m2/repository");
        LocalRepository localRepo = new LocalRepository(mavenLocal);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setTransferListener((TransferListener)new LoggingMavenTransferListener());
        session.setRepositoryListener((RepositoryListener)new LoggingMavenRepositoryListener());
        session.setSystemProperties(sysProps);
        session.setConfigProperties(sysProps);
        SimpleArtifactDescriptorPolicy policy = new SimpleArtifactDescriptorPolicy(0);
        session.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)policy);
        return session;
    }

    private static List<RemoteRepository> newRepositories() {
        return new ArrayList<RemoteRepository>(Collections.singletonList(MavenClasspathEntry.newCentralRepository()));
    }

    private static RemoteRepository newCentralRepository() {
        return new RemoteRepository.Builder("central", "default", "https://repo.maven.apache.org/maven2/").build();
    }
}

