/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.server.exec.imports;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.StringUtils;

class RegisterBeanDefinitionsInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private Log logger = LogFactory.getLog(this.getClass());
    static final String ADDITIONAL_BEAN_CLASS_NAMES = "testjars.additionalBeanClassNames";

    RegisterBeanDefinitionsInitializer() {
    }

    public void initialize(GenericApplicationContext applicationContext) {
        String additionalBeanClassNames = applicationContext.getEnvironment().getProperty(ADDITIONAL_BEAN_CLASS_NAMES);
        if (StringUtils.hasLength((String)additionalBeanClassNames)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Adding the following additional classes to the ApplicationContext " + additionalBeanClassNames));
            }
            for (String beanClassName : StringUtils.delimitedListToStringArray((String)additionalBeanClassNames, (String)",")) {
                try {
                    Class<?> config = applicationContext.getClassLoader().loadClass(beanClassName);
                    applicationContext.registerBeanDefinition("testjars_" + config.getName(), (BeanDefinition)new RootBeanDefinition(config));
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException("Unable to register bean of type " + beanClassName, ex);
                }
            }
        }
    }
}

