/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.server.exec;

import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.function.Consumer;

final class ApplicationPortFileWatcher {
    private final File applicationPortFile;
    private final Consumer<WatchService> registerWatchService;

    ApplicationPortFileWatcher(File applicationPortFile, Consumer<WatchService> registerWatchService) {
        this.applicationPortFile = applicationPortFile;
        this.registerWatchService = registerWatchService;
    }

    ApplicationPortFileWatcher(File applicationPortFile) {
        this(applicationPortFile, watchService -> {});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getApplicationPort() throws InterruptedException {
        try (WatchService watch = FileSystems.getDefault().newWatchService();){
            this.registerWatchService.accept(watch);
            this.applicationPortFile.getParentFile().toPath().register(watch, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
            Integer port = this.readPort();
            do {
                WatchKey watchKey;
                if (port != null) return port;
                try {
                    watchKey = watch.take();
                }
                catch (ClosedWatchServiceException ex) {
                    throw (InterruptedException)new InterruptedException().initCause(ex);
                }
                port = this.readPort();
                watchKey.reset();
            } while (port == null);
            int n = port;
            return n;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Integer readPort() throws IOException {
        if (!this.applicationPortFile.exists()) {
            return null;
        }
        String applicationPort = Files.readString(this.applicationPortFile.toPath());
        if (applicationPort == null || applicationPort.isBlank()) {
            return null;
        }
        return Integer.parseInt(applicationPort);
    }
}

