/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.server.exec;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.experimental.boot.server.exec.ClasspathEntry;
import org.springframework.experimental.boot.server.exec.FileClasspathEntry;
import org.springframework.experimental.boot.server.exec.ResourceClasspathEntry;
import org.springframework.experimental.boot.server.exec.ScanningClasspathEntry;

public class ClasspathBuilder {
    private List<ClasspathEntry> classpath = new ArrayList<ClasspathEntry>();

    public ClasspathBuilder classes(Class<?> ... classes) {
        Arrays.stream(classes).map(ResourceClasspathEntry::new).forEachOrdered(this.classpath::add);
        return this;
    }

    public ClasspathBuilder entries(ClasspathEntry ... entries) {
        Arrays.stream(entries).forEachOrdered(this.classpath::add);
        return this;
    }

    public ClasspathBuilder files(String ... classpathEntries) {
        Arrays.stream(classpathEntries).map(FileClasspathEntry::new).forEachOrdered(this.classpath::add);
        return this;
    }

    public ClasspathBuilder scan(Class<?> clazz) {
        this.classpath.add(new ScanningClasspathEntry(clazz));
        return this;
    }

    String build() {
        return this.classpath.stream().flatMap(entry -> entry.resolve().stream()).collect(Collectors.joining(File.pathSeparator));
    }

    void cleanup() {
        this.classpath.stream().forEachOrdered(ClasspathEntry::cleanup);
    }

    List<ClasspathEntry> getClasspath() {
        return this.classpath;
    }
}

