/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.server.exec;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.experimental.boot.server.exec.ClasspathBuilder;
import org.springframework.experimental.boot.server.exec.CommonsExecWebServer;
import org.springframework.experimental.boot.server.exec.ResourceClasspathEntry;
import org.springframework.experimental.boot.server.exec.ScanningClasspathEntry;
import org.springframework.experimental.boot.server.exec.imports.GenericSpringBootApplicationMain;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CommonsExecWebServerFactoryBean
implements SmartFactoryBean<CommonsExecWebServer>,
DisposableBean,
BeanNameAware,
SmartInitializingSingleton {
    private static Log logger = LogFactory.getLog(CommonsExecWebServerFactoryBean.class);
    private static final String GENERIC_SPRING_BOOT_MAIN_CLASSNAME = GenericSpringBootApplicationMain.class.getName();
    private String executable = CommonsExecWebServerFactoryBean.currentJavaExecutable();
    private ClasspathBuilder classpath = new ClasspathBuilder();
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private String mainClass = "org.springframework.experimental.boot.server.exec.detector.SpringBootFatJarMain";
    private File applicationPortFile = CommonsExecWebServerFactoryBean.createApplicationPortFile();
    private CommonsExecWebServer webServer;
    private final DebugSettings debugSettings = new DebugSettings();
    private boolean useRandomPort = true;

    CommonsExecWebServerFactoryBean() {
        Class jarDetector = ClassUtils.resolveClassName((String)this.mainClass, null);
        this.classpath.entries(new ResourceClasspathEntry("org/springframework/experimental/boot/testjars/classpath-entries/META-INF/spring.factories", "META-INF/spring.factories"), new ScanningClasspathEntry(jarDetector));
    }

    public static CommonsExecWebServerFactoryBean builder() {
        return new CommonsExecWebServerFactoryBean();
    }

    private static File createApplicationPortFile() {
        try {
            return File.createTempFile("application-", ".port");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public CommonsExecWebServerFactoryBean useGenericSpringBootMain() {
        this.mainClass(GENERIC_SPRING_BOOT_MAIN_CLASSNAME);
        Class mainClass = ClassUtils.resolveClassName((String)GENERIC_SPRING_BOOT_MAIN_CLASSNAME, null);
        return this.classpath(classpath -> classpath.scan(mainClass));
    }

    public CommonsExecWebServerFactoryBean mainClass(String mainClass) {
        Assert.notNull((Object)mainClass, (String)"mainClass cannot be null");
        this.mainClass = mainClass;
        return this;
    }

    public CommonsExecWebServerFactoryBean classpath(Consumer<ClasspathBuilder> configure) {
        configure.accept(this.classpath);
        return this;
    }

    public CommonsExecWebServerFactoryBean setAdditionalBeanClassNames(String ... additionalBeanClassNames) {
        return this.systemProperties(props -> props.put("testjars.additionalBeanClassNames", StringUtils.arrayToCommaDelimitedString((Object[])additionalBeanClassNames)));
    }

    public CommonsExecWebServerFactoryBean useRandomPort(boolean useRandomPort) {
        this.useRandomPort = useRandomPort;
        return this;
    }

    public CommonsExecWebServerFactoryBean systemProperties(Consumer<Map<String, String>> systemProperties) {
        systemProperties.accept(this.systemProperties);
        return this;
    }

    public CommonsExecWebServerFactoryBean debug(Consumer<DebugSettings> debugSettings) {
        debugSettings.accept(this.debugSettings);
        return this;
    }

    public boolean isEagerInit() {
        return true;
    }

    private CommonsExecWebServer build() {
        CommandLine commandLine = new CommandLine(this.executable);
        if (this.debugSettings.enabled) {
            String s = this.debugSettings.suspend ? "y" : "n";
            commandLine.addArgument("-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + s + ",address=*:" + this.debugSettings.port);
        }
        commandLine.addArguments(this.createSystemPropertyArgs(), false);
        commandLine.addArgument("-classpath", false);
        commandLine.addArgument(this.classpath.build(), false);
        commandLine.addArgument(this.mainClass);
        return new CommonsExecWebServer(commandLine, this.applicationPortFile, () -> this.classpath.cleanup());
    }

    private String[] createSystemPropertyArgs() {
        HashMap<String, String> systemPropertyArgs = new HashMap<String, String>(this.systemProperties);
        systemPropertyArgs.put("PORTFILE", this.applicationPortFile.getAbsolutePath());
        if (this.useRandomPort) {
            systemPropertyArgs.put("server.port", "0");
        }
        return (String[])systemPropertyArgs.entrySet().stream().map(e -> "-D" + (String)e.getKey() + "=" + (String)e.getValue()).toArray(String[]::new);
    }

    private static String currentJavaExecutable() {
        ProcessHandle processHandle = ProcessHandle.current();
        return processHandle.info().command().get();
    }

    public CommonsExecWebServer getObject() throws Exception {
        if (this.webServer == null) {
            this.webServer = this.build();
            this.webServer.start();
        }
        return this.webServer;
    }

    public Class<?> getObjectType() {
        return CommonsExecWebServer.class;
    }

    public void setBeanName(String beanName) {
        String basePath = "testjars/" + beanName;
        this.classpath.entries(new ScanningClasspathEntry(basePath));
    }

    public void destroy() throws Exception {
        if (this.webServer != null) {
            this.webServer.destroy();
        }
    }

    public void afterSingletonsInstantiated() {
        if (this.webServer != null) {
            this.webServer.getPort();
        }
    }

    public static class DebugSettings {
        private boolean enabled;
        private int port = 5005;
        private boolean suspend = true;

        public DebugSettings enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public DebugSettings port(int port) {
            this.port = port;
            return this;
        }

        public DebugSettings suspend(boolean suspend) {
            this.suspend = suspend;
            return this;
        }
    }
}

