/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.server.exec;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.springframework.experimental.boot.server.exec.ClasspathEntry;

public class FileClasspathEntry
implements ClasspathEntry {
    private final File file;

    public FileClasspathEntry(String file) {
        this(new File(file));
    }

    public FileClasspathEntry(File file) {
        this.file = file;
    }

    @Override
    public List<String> resolve() {
        String absolutePath = this.file.getAbsolutePath();
        if (!this.file.exists()) {
            throw new IllegalStateException("Could not find file to add to the classpath '" + absolutePath + "'");
        }
        return Arrays.asList(absolutePath);
    }
}

