/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.server.exec.detector;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.boot.loader.log.DebugLogger;
import org.springframework.experimental.boot.server.exec.detector.ClassUtils;

public class SpringBootFatJarMain {
    private static DebugLogger debug = DebugLogger.get(SpringBootFatJarMain.class);
    static final String SPRING_BOOT_32_PLUS_LAUNCHER_CLASSNAME = "org.springframework.boot.loader.launch.JarLauncher";
    static final String SPRING_BOOT_PRE_32_LAUNCHER_CLASSNAME = "org.springframework.boot.loader.JarLauncher";

    public static void main(String[] args) {
        if (SpringBootFatJarMain.runMain(SPRING_BOOT_32_PLUS_LAUNCHER_CLASSNAME, args, "Spring Boot >= 3.2 fat jar")) {
            return;
        }
        if (SpringBootFatJarMain.runMain(SPRING_BOOT_PRE_32_LAUNCHER_CLASSNAME, args, "Spring Boot < 3.2 fat jar")) {
            return;
        }
        String classPath = System.getProperty("java.class.path");
        throw new IllegalStateException("The application could not be launched as a Spring Boot fat jar using the classpath " + classPath + "\n  - If you expect the application to run as a fat jar, ensure that the classpath includes the Spring Boot fat jar\n  - If you are not using a fat jar, ensure to specify the main class using CommonsExecWebServerFactoryBean.mainClass(String)\n  - If your application is an adhoc application that does not contain a main class, you can use CommonsExecWebServerFactoryBean.useGenericSpringBootMain()");
    }

    private static boolean runMain(String className, String[] args, String description) {
        debug.log("Trying to run as %s using %s.main(String[])", (Object)description, (Object)className);
        try {
            Class<?> jarLauncher = ClassUtils.forName(className, SpringBootFatJarMain.class.getClassLoader());
            Method mainMethod = jarLauncher.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{args});
            debug.log("Successfully ran as %s", (Object)description);
            return true;
        }
        catch (ClassNotFoundException ex) {
            debug.log("Failed to run as %s", (Object)description, (Object)ex);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return false;
    }
}

