/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.test.context;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.testcontainers.properties.TestcontainersPropertySource;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.experimental.boot.test.context.DynamicProperty;
import org.springframework.experimental.boot.test.context.DynamicPropertyRegistryProperty;
import org.springframework.experimental.boot.test.context.DynamicPropertyRegistryPropertyFactory;
import org.springframework.test.context.DynamicPropertyRegistrar;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.util.ClassUtils;

class DynamicPropertyDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    public static final String REGISTRAR_BEAN_NAME = "testjarsDynamicPropertyRegistryPropertyRegistrar";
    private final DynamicPropertyRegistryPropertyFactory registryPropertyFactory = new DynamicPropertyRegistryPropertyFactory();
    private final BeanFactory beanFactory;
    private final Environment environment;

    DynamicPropertyDefinitionRegistrar(BeanFactory beanFactory, Environment environment) {
        this.beanFactory = beanFactory;
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(REGISTRAR_BEAN_NAME)) {
            return;
        }
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory listableBeanFactory = (ConfigurableListableBeanFactory)beanFactory;
            if (ClassUtils.isPresent((String)"org.springframework.test.context.DynamicPropertyRegistrar", (ClassLoader)this.getClass().getClassLoader())) {
                this.registerDynamicPropertyRegistrar(listableBeanFactory, registry);
            } else {
                this.registerTestcontainersPropertySource(listableBeanFactory, registry);
            }
        }
    }

    private void registerDynamicPropertyRegistrar(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry) {
        ArrayList<DynamicPropertyRegistryProperty> properties = new ArrayList<DynamicPropertyRegistryProperty>();
        for (String dynamicPropertyBeanName : beanFactory.getBeanNamesForAnnotation(DynamicProperty.class)) {
            BeanDefinition dynamicPropertyBeanDefinition = registry.getBeanDefinition(dynamicPropertyBeanName);
            DynamicPropertyRegistryProperty property = this.createRegistryProperty(dynamicPropertyBeanDefinition, dynamicPropertyBeanName);
            if (property == null) {
                throw new IllegalStateException("Missing @DynamicProperty annotation on BeanDefinition of " + dynamicPropertyBeanName);
            }
            properties.add(property);
        }
        BeanDefinitionBuilder registrarBdb = BeanDefinitionBuilder.rootBeanDefinition(DynamicPropertyRegistryPropertyRegistrar.class);
        registrarBdb.addConstructorArgValue(properties);
        registry.registerBeanDefinition(REGISTRAR_BEAN_NAME, (BeanDefinition)registrarBdb.getBeanDefinition());
    }

    private void registerTestcontainersPropertySource(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry) {
        DynamicPropertyRegistry properties = TestcontainersPropertySource.attach((Environment)this.environment);
        for (String dynamicPropertyBeanName : beanFactory.getBeanNamesForAnnotation(DynamicProperty.class)) {
            BeanDefinition dynamicPropertyBeanDefinition = registry.getBeanDefinition(dynamicPropertyBeanName);
            DynamicPropertyRegistryProperty property = this.createRegistryProperty(dynamicPropertyBeanDefinition, dynamicPropertyBeanName);
            if (property == null) {
                throw new IllegalStateException("Missing @DynamicProperty annotation on BeanDefinition of " + dynamicPropertyBeanName);
            }
            properties.add(property.name(), property.value());
        }
    }

    private DynamicPropertyRegistryProperty createRegistryProperty(BeanDefinition dynamicPropertyBeanDefinition, String dynamicPropertyBeanName) {
        if (dynamicPropertyBeanDefinition instanceof AnnotatedBeanDefinition) {
            AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)dynamicPropertyBeanDefinition;
            MethodMetadata metadata = annotatedBeanDefinition.getFactoryMethodMetadata();
            MergedAnnotation dynamicPropertyMergedAnnotation = metadata.getAnnotations().get(DynamicProperty.class);
            return this.registryPropertyFactory.createRegistryProperty((MergedAnnotation<DynamicProperty>)dynamicPropertyMergedAnnotation, () -> this.beanFactory.getBean(dynamicPropertyBeanName));
        }
        return null;
    }

    static class DynamicPropertyRegistryPropertyRegistrar
    implements DynamicPropertyRegistrar {
        private final List<DynamicPropertyRegistryProperty> properties;

        DynamicPropertyRegistryPropertyRegistrar(List<DynamicPropertyRegistryProperty> properties) {
            this.properties = properties;
        }

        public void accept(DynamicPropertyRegistry registry) {
            for (DynamicPropertyRegistryProperty property : this.properties) {
                registry.add(property.name(), property.value());
            }
        }
    }
}

