/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.experimental.boot.autoconfigure.r2dbc.observation;

import io.micrometer.common.lang.Nullable;
import io.micrometer.observation.ObservationRegistry;
import io.r2dbc.proxy.ProxyConnectionFactory;
import io.r2dbc.proxy.listener.ProxyExecutionListener;
import io.r2dbc.proxy.observation.ObservationProxyExecutionListener;
import io.r2dbc.spi.ConnectionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.experimental.boot.autoconfigure.r2dbc.observation.R2dbcObservationProperties;

public class R2dbcObservationConnectionFactoryBeanPostProcessor
implements BeanPostProcessor {
    private final R2dbcObservationProperties observationProperties;
    private final ObjectProvider<ObservationRegistry> observationRegistry;
    private final String url;

    public R2dbcObservationConnectionFactoryBeanPostProcessor(R2dbcObservationProperties observationProperties, ObjectProvider<ObservationRegistry> observationRegistry, @Nullable String url) {
        this.observationProperties = observationProperties;
        this.observationRegistry = observationRegistry;
        this.url = url;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ConnectionFactory) {
            ConnectionFactory connectionFactory = (ConnectionFactory)bean;
            ObservationProxyExecutionListener listener = new ObservationProxyExecutionListener((ObservationRegistry)this.observationRegistry.getObject(), connectionFactory, this.url);
            listener.setIncludeParameterValues(this.observationProperties.isIncludeParameterValues());
            ConnectionFactory proxyConnectionFactory = ProxyConnectionFactory.builder((ConnectionFactory)connectionFactory).listener((ProxyExecutionListener)listener).build();
            return proxyConnectionFactory;
        }
        return bean;
    }
}

