/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jpa;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import java.time.Instant;
import java.util.UUID;
import org.springframework.util.Assert;

@Entity
class JpaEventPublication {
    @Id
    @Column(length=16)
    final UUID id;
    final Instant publicationDate;
    final String listenerId;
    final String serializedEvent;
    final Class<?> eventType;
    Instant completionDate;

    JpaEventPublication(Instant publicationDate, String listenerId, String serializedEvent, Class<?> eventType) {
        Assert.notNull((Object)publicationDate, (String)"Publication date must not be null!");
        Assert.notNull((Object)listenerId, (String)"Listener id must not be null or empty!");
        Assert.notNull((Object)serializedEvent, (String)"Serialized event must not be null or empty!");
        Assert.notNull(eventType, (String)"Event type must not be null!");
        this.id = UUID.randomUUID();
        this.publicationDate = publicationDate;
        this.listenerId = listenerId;
        this.serializedEvent = serializedEvent;
        this.eventType = eventType;
    }

    JpaEventPublication() {
        this.id = null;
        this.publicationDate = null;
        this.listenerId = null;
        this.serializedEvent = null;
        this.eventType = null;
    }

    JpaEventPublication markCompleted() {
        this.completionDate = Instant.now();
        return this;
    }
}

