/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.boot.autoconfigure;

import java.util.Optional;
import org.apache.geode.cache.GemFireCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;
import org.springframework.geode.boot.autoconfigure.condition.ConditionalOnMissingProperty;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={CacheFactoryBean.class, GemFireCache.class})
public class CacheNameAutoConfiguration {
    private static final String GEMFIRE_NAME_PROPERTY = "name";
    private static final String SPRING_APPLICATION_NAME_PROPERTY = "spring.application.name";
    private static final String SPRING_DATA_GEMFIRE_CACHE_NAME_PROPERTY = "spring.data.gemfire.cache.name";
    private static final String SPRING_DATA_GEMFIRE_NAME_PROPERTY = "spring.data.gemfire.name";
    private static final String SPRING_DATA_GEODE_CACHE_NAME_PROPERTY = "spring.data.geode.cache.name";
    private static final String SPRING_DATA_GEODE_NAME_PROPERTY = "spring.data.geode.name";

    @Bean
    @Order(value=-2147483647)
    @ConditionalOnMissingProperty(value={"spring.data.gemfire.cache.name", "spring.data.gemfire.name", "spring.data.geode.cache.name", "spring.data.geode.name"})
    ClientCacheConfigurer clientCacheNameConfigurer(Environment environment) {
        return (beanName, clientCacheFactoryBean) -> this.configureCacheName(environment, (CacheFactoryBean)clientCacheFactoryBean);
    }

    @Bean
    @Order(value=-2147483647)
    @ConditionalOnMissingProperty(value={"spring.data.gemfire.cache.name", "spring.data.gemfire.name", "spring.data.geode.cache.name", "spring.data.geode.name"})
    PeerCacheConfigurer peerCacheNameConfigurer(Environment environment) {
        return (beanName, peerCacheFactoryBean) -> this.configureCacheName(environment, (CacheFactoryBean)peerCacheFactoryBean);
    }

    private void configureCacheName(Environment environment, CacheFactoryBean cacheFactoryBean) {
        String springApplicationName = this.resolveSpringApplicationName(environment);
        if (StringUtils.hasText((String)springApplicationName)) {
            this.setGemFireName(cacheFactoryBean, springApplicationName);
        }
    }

    private String resolveSpringApplicationName(Environment environment) {
        return Optional.ofNullable(environment).filter(it -> it.containsProperty(SPRING_APPLICATION_NAME_PROPERTY)).map(it -> it.getProperty(SPRING_APPLICATION_NAME_PROPERTY)).filter(StringUtils::hasText).orElse(null);
    }

    private void setGemFireName(CacheFactoryBean cacheFactoryBean, String gemfireName) {
        cacheFactoryBean.getProperties().setProperty(GEMFIRE_NAME_PROPERTY, gemfireName);
    }
}

