/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.boot.autoconfigure;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionService;
import org.apache.geode.internal.concurrent.ConcurrentHashSet;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.gemfire.GemfireAccessor;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.geode.boot.autoconfigure.ClientCacheAutoConfiguration;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureAfter(value={ClientCacheAutoConfiguration.class})
@ConditionalOnBean(value={GemFireCache.class})
@ConditionalOnClass(value={GemfireTemplate.class})
public class RegionTemplateAutoConfiguration {
    private static final Set<String> regionTemplateNames = new ConcurrentHashSet();

    private String toRegionTemplateName(String regionName) {
        return StringUtils.uncapitalize((String)regionName) + "Template";
    }

    @Bean
    BeanPostProcessor regionTemplateBeanPostProcessor(final ConfigurableApplicationContext applicationContext) {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof Region) {
                    String regionTemplateName = RegionTemplateAutoConfiguration.this.toRegionTemplateName(beanName);
                    this.registerRegionTemplateBean(regionTemplateName, bean);
                }
                return bean;
            }

            private void registerRegionTemplateBean(String regionTemplateName, Object bean) {
                Optional.ofNullable(applicationContext).filter(it -> bean instanceof Region).filter(it -> !it.containsBean(regionTemplateName)).filter(it -> RegionTemplateAutoConfiguration.this.isGemfireTemplateWithRegionNotPresent((ApplicationContext)it, (Region)bean)).map(ConfigurableApplicationContext::getBeanFactory).filter(SingletonBeanRegistry.class::isInstance).map(SingletonBeanRegistry.class::cast).ifPresent(beanFactory -> {
                    beanFactory.registerSingleton(regionTemplateName, (Object)new GemfireTemplate((Region)bean));
                    regionTemplateNames.add(regionTemplateName);
                });
            }
        };
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void registerRemainingRegionTemplatesOnContextRefresh(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
            Optional.ofNullable(applicationContext.getBean(GemFireCache.class)).map(RegionService::rootRegions).ifPresent(rootRegions -> rootRegions.stream().filter(Objects::nonNull).filter(region -> !regionTemplateNames.contains(this.toRegionTemplateName(region.getName()))).filter(region -> !applicationContext.containsBean(this.toRegionTemplateName(region.getName()))).filter(region -> this.isGemfireTemplateWithRegionNotPresent(applicationContext, (Region)region)).forEach(region -> beanFactory.registerSingleton(this.toRegionTemplateName(region.getName()), (Object)new GemfireTemplate(region))));
        }
    }

    private boolean isGemfireTemplateWithRegionNotPresent(ApplicationContext applicationContext, Region region) {
        Map gemfireTemplateBeans = applicationContext.getBeansOfType(GemfireTemplate.class, false, false);
        return CollectionUtils.nullSafeMap((Map)gemfireTemplateBeans).values().stream().map(GemfireAccessor::getRegion).noneMatch(templateRegion -> templateRegion.equals((Object)region));
    }
}

