/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.boot.autoconfigure;

import java.util.Properties;
import java.util.Set;
import org.apache.geode.cache.GemFireCache;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.geode.boot.autoconfigure.ClientCacheAutoConfiguration;
import org.springframework.session.data.gemfire.config.annotation.web.http.EnableGemFireHttpSession;
import org.springframework.session.data.gemfire.config.annotation.web.http.GemFireHttpSessionConfiguration;
import org.springframework.session.web.http.SessionRepositoryFilter;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureAfter(value={ClientCacheAutoConfiguration.class})
@Conditional(value={SpringSessionStoreTypeCondition.class})
@ConditionalOnBean(value={GemFireCache.class})
@ConditionalOnClass(value={GemFireCache.class, GemFireHttpSessionConfiguration.class})
@ConditionalOnMissingBean(value={SessionRepositoryFilter.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableGemFireHttpSession
public class SpringSessionAutoConfiguration {
    protected static final Set<String> SPRING_SESSION_STORE_TYPES = CollectionUtils.asSet((Object[])new String[]{"gemfire", "geode"});
    protected static final String SERVER_SERVLET_SESSION_TIMEOUT_PROPERTY = "server.servlet.session.timeout";
    protected static final String SPRING_SESSION_DATA_GEMFIRE_SESSION_EXPIRATION_TIMEOUT = "spring.session.data.gemfire.session.expiration.max-inactive-interval-seconds";
    protected static final String SPRING_SESSION_PROPERTY_SOURCE_NAME = "SpringSessionProperties";
    protected static final String SPRING_SESSION_STORE_TYPE_PROPERTY = "spring.session.store-type";
    protected static final String SPRING_SESSION_TIMEOUT_PROPERTY = "spring.session.timeout";

    protected static boolean isNotSet(ConfigurableEnvironment environment, String propertyName) {
        return !SpringSessionAutoConfiguration.isSet(environment, propertyName);
    }

    protected static boolean isSet(ConfigurableEnvironment environment, String propertyName) {
        return environment.containsProperty(propertyName) && StringUtils.hasText((String)environment.getProperty(propertyName));
    }

    protected static class SpringSessionStoreTypeCondition
    implements Condition {
        protected SpringSessionStoreTypeCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String springSessionStoreTypeValue = context.getEnvironment().getProperty(SpringSessionAutoConfiguration.SPRING_SESSION_STORE_TYPE_PROPERTY);
            return !StringUtils.hasText((String)springSessionStoreTypeValue) || SPRING_SESSION_STORE_TYPES.contains(springSessionStoreTypeValue.trim().toLowerCase());
        }
    }

    public static class SpringSessionPropertiesEnvironmentPostProcessor
    implements EnvironmentPostProcessor {
        public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
            if (SpringSessionAutoConfiguration.isNotSet(environment, SpringSessionAutoConfiguration.SPRING_SESSION_DATA_GEMFIRE_SESSION_EXPIRATION_TIMEOUT)) {
                Properties springSessionProperties = new Properties();
                if (SpringSessionAutoConfiguration.isSet(environment, SpringSessionAutoConfiguration.SPRING_SESSION_TIMEOUT_PROPERTY)) {
                    springSessionProperties.setProperty(SpringSessionAutoConfiguration.SPRING_SESSION_DATA_GEMFIRE_SESSION_EXPIRATION_TIMEOUT, environment.getProperty(SpringSessionAutoConfiguration.SPRING_SESSION_TIMEOUT_PROPERTY));
                } else if (SpringSessionAutoConfiguration.isSet(environment, SpringSessionAutoConfiguration.SERVER_SERVLET_SESSION_TIMEOUT_PROPERTY)) {
                    springSessionProperties.setProperty(SpringSessionAutoConfiguration.SPRING_SESSION_DATA_GEMFIRE_SESSION_EXPIRATION_TIMEOUT, environment.getProperty(SpringSessionAutoConfiguration.SERVER_SERVLET_SESSION_TIMEOUT_PROPERTY));
                }
                if (!springSessionProperties.isEmpty()) {
                    environment.getPropertySources().addFirst(this.newPropertySource(SpringSessionAutoConfiguration.SPRING_SESSION_PROPERTY_SOURCE_NAME, springSessionProperties));
                }
            }
        }

        private PropertySource<?> newPropertySource(String name, Properties properties) {
            return new PropertiesPropertySource(name, properties);
        }
    }
}

