/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.boot.autoconfigure.configuration.support;

import org.apache.geode.cache.DiskStoreFactory;

public class DiskStoreProperties {
    private final StoreProperties storeProperties = new StoreProperties();

    public StoreProperties getStore() {
        return this.storeProperties;
    }

    public static class StoreProperties {
        private boolean allowForceCompaction = false;
        private boolean autoCompact = true;
        private float diskUsageCriticalPercentage = 99.0f;
        private float diskUsageWarningPercentage = 90.0f;
        private int compactionThreshold = 50;
        private int queueSize = 0;
        private int writeBufferSize = 32768;
        private long maxOplogSize = DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE;
        private long timeInterval = 1000L;
        private DirectoryProperties[] directoryProperties = new DirectoryProperties[0];

        public boolean isAllowForceCompaction() {
            return this.allowForceCompaction;
        }

        public void setAllowForceCompaction(boolean allowForceCompaction) {
            this.allowForceCompaction = allowForceCompaction;
        }

        public boolean isAutoCompact() {
            return this.autoCompact;
        }

        public void setAutoCompact(boolean autoCompact) {
            this.autoCompact = autoCompact;
        }

        public int getCompactionThreshold() {
            return this.compactionThreshold;
        }

        public void setCompactionThreshold(int compactionThreshold) {
            this.compactionThreshold = compactionThreshold;
        }

        public DirectoryProperties[] getDirectory() {
            return this.directoryProperties;
        }

        public void setDirectory(DirectoryProperties[] directoryProperties) {
            this.directoryProperties = directoryProperties;
        }

        public float getDiskUsageCriticalPercentage() {
            return this.diskUsageCriticalPercentage;
        }

        public void setDiskUsageCriticalPercentage(float diskUsageCriticalPercentage) {
            this.diskUsageCriticalPercentage = diskUsageCriticalPercentage;
        }

        public float getDiskUsageWarningPercentage() {
            return this.diskUsageWarningPercentage;
        }

        public void setDiskUsageWarningPercentage(float diskUsageWarningPercentage) {
            this.diskUsageWarningPercentage = diskUsageWarningPercentage;
        }

        public long getMaxOplogSize() {
            return this.maxOplogSize;
        }

        public void setMaxOplogSize(long maxOplogSize) {
            this.maxOplogSize = maxOplogSize;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }

        public long getTimeInterval() {
            return this.timeInterval;
        }

        public void setTimeInterval(long timeInterval) {
            this.timeInterval = timeInterval;
        }

        public int getWriteBufferSize() {
            return this.writeBufferSize;
        }

        public void setWriteBufferSize(int writeBufferSize) {
            this.writeBufferSize = writeBufferSize;
        }
    }

    public static class DirectoryProperties {
        private int size = Integer.MAX_VALUE;
        private String location;

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }
}

