/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.geode.config.annotation.UseGroups;
import org.springframework.util.StringUtils;

@Configuration
public class GroupsConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    private static final String GEMFIRE_GROUPS_PROPERTY = "groups";
    private String[] groups = new String[0];

    protected Class<? extends Annotation> getAnnotationType() {
        return UseGroups.class;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        if (this.isAnnotationPresent(importMetadata)) {
            AnnotationAttributes inGroupsAttributes = this.getAnnotationAttributes(importMetadata);
            this.setGroups(inGroupsAttributes.containsKey((Object)"value") ? inGroupsAttributes.getStringArray("value") : null);
            this.setGroups(inGroupsAttributes.containsKey((Object)GEMFIRE_GROUPS_PROPERTY) ? inGroupsAttributes.getStringArray(GEMFIRE_GROUPS_PROPERTY) : null);
        }
    }

    protected void setGroups(String[] groups) {
        this.groups = Optional.ofNullable(groups).filter(it -> ((String[])it).length > 0).orElse(this.groups);
    }

    protected Optional<String[]> getGroups() {
        return Optional.ofNullable(this.groups).filter(it -> ((String[])it).length > 0);
    }

    @Bean
    ClientCacheConfigurer clientCacheGroupsConfigurer() {
        return (beaName, clientCacheFactoryBean) -> this.configureGroups((CacheFactoryBean)clientCacheFactoryBean);
    }

    @Bean
    PeerCacheConfigurer peerCacheGroupsConfigurer() {
        return (beaName, peerCacheFactoryBean) -> this.configureGroups((CacheFactoryBean)peerCacheFactoryBean);
    }

    private void configureGroups(CacheFactoryBean cacheFactoryBean) {
        this.getGroups().ifPresent(groups -> cacheFactoryBean.getProperties().setProperty(GEMFIRE_GROUPS_PROPERTY, StringUtils.arrayToCommaDelimitedString((Object[])groups)));
    }
}

