/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.core.env.support;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.geode.core.env.support.Service;
import org.springframework.geode.core.util.ObjectUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CloudCacheService
extends Service {
    private String locators;
    private URL gfshUrl;

    public static CloudCacheService with(String name) {
        return new CloudCacheService(name);
    }

    private CloudCacheService(String name) {
        super(name);
    }

    public Optional<URL> getGfshUrl() {
        return Optional.ofNullable(this.gfshUrl);
    }

    public Optional<String> getLocators() {
        return Optional.ofNullable(this.locators).filter(StringUtils::hasText);
    }

    public List<Locator> getLocatorList() {
        return this.getLocators().map(Locator::parseLocators).orElseGet(Collections::emptyList);
    }

    public CloudCacheService withGfshUrl(URL gfshUrl) {
        this.gfshUrl = gfshUrl;
        return this;
    }

    public CloudCacheService withLocators(String locators) {
        this.locators = locators;
        return this;
    }

    public static class Locator
    implements Comparable<Locator> {
        static final int DEFAULT_LOCATOR_PORT = 10334;
        static final String DEFAULT_LOCATOR_HOST = "localhost";
        private Integer port;
        private String host;

        public static Locator newLocator() {
            return Locator.newLocator(DEFAULT_LOCATOR_HOST, 10334);
        }

        public static Locator newLocator(int port) {
            return Locator.newLocator(DEFAULT_LOCATOR_HOST, port);
        }

        public static Locator newLocator(String host) {
            return Locator.newLocator(host, 10334);
        }

        public static Locator newLocator(String host, int port) {
            Assert.hasText((String)host, (String)String.format("Host [%s] is required", host));
            Assert.isTrue((port > -1 ? 1 : 0) != 0, (String)String.format("Port [%d] must be greater than equal to 0", port));
            return new Locator(host, port);
        }

        public static List<Locator> parseLocators(String locators) {
            return Arrays.stream(String.valueOf(locators).split(",")).filter(StringUtils::hasText).map(Locator::parse).collect(Collectors.toList());
        }

        public static Locator parse(String hostPort) {
            return Optional.ofNullable(hostPort).filter(StringUtils::hasText).map(it -> {
                String host = Locator.parseHost(it);
                int port = Locator.parsePort(it);
                return Locator.newLocator(host, port);
            }).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException((String)"Locator host/port [%s] is not valid", (Object[])new Object[]{hostPort}));
        }

        private static String parseHost(String value) {
            int index = String.valueOf(value).trim().indexOf("[");
            return index > 0 ? value.trim().substring(0, index).trim() : (index != 0 && StringUtils.hasText((String)value) ? value.trim() : DEFAULT_LOCATOR_HOST);
        }

        private static int parsePort(String value) {
            StringBuilder digits = new StringBuilder();
            for (char chr : String.valueOf(value).toCharArray()) {
                if (!Character.isDigit(chr)) continue;
                digits.append(chr);
            }
            return digits.length() > 0 ? Integer.valueOf(digits.toString()) : 10334;
        }

        private Locator(String host, Integer port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return StringUtils.hasText((String)this.host) ? this.host : DEFAULT_LOCATOR_HOST;
        }

        public int getPort() {
            return this.port != null ? this.port : 10334;
        }

        @Override
        public int compareTo(Locator other) {
            int result = this.getHost().compareTo(other.getHost());
            return result != 0 ? result : this.getPort() - other.getPort();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Locator)) {
                return false;
            }
            Locator that = (Locator)obj;
            return this.getHost().equals(that.getHost()) && this.getPort() == that.getPort();
        }

        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getHost());
            hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getPort());
            return hashValue;
        }

        public String toString() {
            return String.format("%s[%d]", this.getHost(), this.getPort());
        }
    }
}

