/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.security.support;

import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.ResourcePermission;
import org.apache.geode.security.SecurityManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.gemfire.support.LazyWiringDeclarableSupport;
import org.springframework.util.Assert;

public class SecurityManagerProxy
extends LazyWiringDeclarableSupport
implements SecurityManager,
DisposableBean,
BeanFactoryAware {
    private static final AtomicReference<SecurityManagerProxy> INSTANCE = new AtomicReference();
    private BeanFactory beanFactory;
    private SecurityManager securityManager;

    public static SecurityManagerProxy getInstance() {
        SecurityManagerProxy securityManagerProxy = INSTANCE.get();
        Assert.state((securityManagerProxy != null ? 1 : 0) != 0, (String)"SecurityManagerProxy was not configured");
        return securityManagerProxy;
    }

    public SecurityManagerProxy() {
        INSTANCE.compareAndSet(null, this);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Autowired
    public void setSecurityManager(SecurityManager securityManager) {
        Assert.notNull((Object)securityManager, (String)"SecurityManager must not be null");
        this.securityManager = securityManager;
    }

    protected SecurityManager getSecurityManager() {
        Assert.state((this.securityManager != null ? 1 : 0) != 0, (String)"No SecurityManager configured");
        return this.securityManager;
    }

    public Object authenticate(Properties properties) throws AuthenticationFailedException {
        return this.getSecurityManager().authenticate(properties);
    }

    public boolean authorize(Object principal, ResourcePermission permission) {
        return this.getSecurityManager().authorize(principal, permission);
    }

    public void close() {
        this.getSecurityManager().close();
    }

    public void destroy() throws Exception {
        super.destroy();
        INSTANCE.set(null);
    }

    protected BeanFactory locateBeanFactory() {
        return Optional.ofNullable(this.beanFactory).orElseGet(() -> super.locateBeanFactory());
    }
}

