/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.time.Duration;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.core.io.ClassPathResource;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.ResponseError;
import org.springframework.graphql.client.AbstractGraphQlClientBuilder;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.graphql.client.GraphQlTransport;
import org.springframework.graphql.support.DocumentSource;
import org.springframework.graphql.support.ResourceDocumentSource;
import org.springframework.graphql.test.tester.DefaultGraphQlTester;
import org.springframework.graphql.test.tester.GraphQlTester;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractGraphQlTesterBuilder<B extends AbstractGraphQlTesterBuilder<B>>
implements GraphQlTester.Builder<B> {
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)AbstractGraphQlClientBuilder.class.getClassLoader());
    private static final Duration DEFAULT_RESPONSE_DURATION = Duration.ofSeconds(5L);
    @Nullable
    private Predicate<ResponseError> errorFilter;
    private DocumentSource documentSource;
    private Configuration jsonPathConfig = Configuration.builder().build();
    private Duration responseTimeout = DEFAULT_RESPONSE_DURATION;

    public AbstractGraphQlTesterBuilder() {
        this.documentSource = AbstractGraphQlTesterBuilder.initDocumentSource();
    }

    private static DocumentSource initDocumentSource() {
        return new ResourceDocumentSource(Collections.singletonList(new ClassPathResource("graphql-test/")), ResourceDocumentSource.FILE_EXTENSIONS);
    }

    @Override
    public B errorFilter(Predicate<ResponseError> predicate) {
        this.errorFilter = this.errorFilter != null ? this.errorFilter.and(predicate) : predicate;
        return (B)this.self();
    }

    @Override
    public B documentSource(DocumentSource documentSource) {
        this.documentSource = documentSource;
        return (B)this.self();
    }

    @Override
    public B responseTimeout(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"'timeout' is required");
        this.responseTimeout = timeout;
        return (B)this.self();
    }

    private <T extends B> T self() {
        return (T)this;
    }

    protected void configureJsonPathConfig(Function<Configuration, Configuration> configurer) {
        this.jsonPathConfig = configurer.apply(this.jsonPathConfig);
    }

    protected GraphQlTester buildGraphQlTester(GraphQlTransport transport) {
        if (jackson2Present) {
            this.configureJsonPathConfig(Jackson2Configurer::configure);
        }
        return new DefaultGraphQlTester(transport, this.errorFilter, this.jsonPathConfig, this.documentSource, this.responseTimeout);
    }

    protected Consumer<AbstractGraphQlTesterBuilder<?>> getBuilderInitializer() {
        return builder -> {
            if (this.errorFilter != null) {
                builder.errorFilter((Predicate)this.errorFilter);
            }
            builder.documentSource(this.documentSource);
            builder.configureJsonPathConfig(config -> this.jsonPathConfig);
            builder.responseTimeout(this.responseTimeout);
        };
    }

    protected static GraphQlTransport asTransport(final GraphQlClient client) {
        return new GraphQlTransport(){

            public Mono<GraphQlResponse> execute(GraphQlRequest request) {
                return client.document(request.getDocument()).operationName(request.getOperationName()).variables(request.getVariables()).execute().cast(GraphQlResponse.class);
            }

            public Flux<GraphQlResponse> executeSubscription(GraphQlRequest request) {
                return client.document(request.getDocument()).operationName(request.getOperationName()).variables(request.getVariables()).executeSubscription().cast(GraphQlResponse.class);
            }
        };
    }

    private static class Jackson2Configurer {
        private static final Class<?> defaultJsonProviderType;
        private static final Class<?> defaultMappingProviderType;

        private Jackson2Configurer() {
        }

        static Configuration configure(Configuration config) {
            if (Jackson2Configurer.isDefault(config.jsonProvider(), defaultJsonProviderType)) {
                config = config.jsonProvider((JsonProvider)new JacksonJsonProvider());
            }
            if (Jackson2Configurer.isDefault(config.mappingProvider(), defaultMappingProviderType)) {
                config = config.mappingProvider((MappingProvider)new JacksonMappingProvider());
            }
            return config;
        }

        private static <T> boolean isDefault(@Nullable T provider, Class<? extends T> defaultProviderType) {
            return provider == null || defaultProviderType.isInstance(provider);
        }

        static {
            Configuration config = Configuration.defaultConfiguration();
            defaultJsonProviderType = config.jsonProvider().getClass();
            defaultMappingProviderType = config.mappingProvider().getClass();
        }
    }
}

