/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.net.URI;
import java.util.function.Consumer;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.graphql.client.WebSocketGraphQlClient;
import org.springframework.graphql.test.tester.AbstractDelegatingGraphQlTester;
import org.springframework.graphql.test.tester.AbstractGraphQlTesterBuilder;
import org.springframework.graphql.test.tester.EncoderDecoderMappingProvider;
import org.springframework.graphql.test.tester.GraphQlTester;
import org.springframework.graphql.test.tester.WebSocketGraphQlTester;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.publisher.Mono;

final class DefaultWebSocketGraphQlTesterBuilder
extends AbstractGraphQlTesterBuilder<DefaultWebSocketGraphQlTesterBuilder>
implements WebSocketGraphQlTester.Builder<DefaultWebSocketGraphQlTesterBuilder> {
    private final WebSocketGraphQlClient.Builder<?> graphQlClientBuilder;

    DefaultWebSocketGraphQlTesterBuilder(String url, WebSocketClient webSocketClient) {
        Assert.notNull((Object)webSocketClient, (String)"WebSocketClient is required");
        this.graphQlClientBuilder = WebSocketGraphQlClient.builder((String)url, (WebSocketClient)webSocketClient);
    }

    DefaultWebSocketGraphQlTesterBuilder(URI url, WebSocketClient webSocketClient) {
        Assert.notNull((Object)webSocketClient, (String)"WebSocketClient is required");
        this.graphQlClientBuilder = WebSocketGraphQlClient.builder((URI)url, (WebSocketClient)webSocketClient);
    }

    DefaultWebSocketGraphQlTesterBuilder(WebSocketGraphQlClient client) {
        Assert.notNull((Object)client, (String)"WebSocketGraphQlClient is required");
        this.graphQlClientBuilder = client.mutate();
    }

    @Override
    public DefaultWebSocketGraphQlTesterBuilder url(String url) {
        this.graphQlClientBuilder.url(url);
        return this;
    }

    @Override
    public DefaultWebSocketGraphQlTesterBuilder url(URI url) {
        this.graphQlClientBuilder.url(url);
        return this;
    }

    @Override
    public DefaultWebSocketGraphQlTesterBuilder header(String name, String ... values) {
        this.graphQlClientBuilder.header(name, values);
        return this;
    }

    @Override
    public DefaultWebSocketGraphQlTesterBuilder headers(Consumer<HttpHeaders> headersConsumer) {
        this.graphQlClientBuilder.headers(headersConsumer);
        return this;
    }

    @Override
    public DefaultWebSocketGraphQlTesterBuilder codecConfigurer(Consumer<CodecConfigurer> codecsConsumer) {
        this.graphQlClientBuilder.codecConfigurer(codecsConsumer);
        return this;
    }

    @Override
    public WebSocketGraphQlTester build() {
        this.registerJsonPathMappingProvider();
        WebSocketGraphQlClient client = this.graphQlClientBuilder.build();
        GraphQlTester graphQlTester = super.buildGraphQlTester(DefaultWebSocketGraphQlTesterBuilder.asTransport((GraphQlClient)client));
        return new DefaultWebSocketGraphQlTester(graphQlTester, client, this.getBuilderInitializer());
    }

    private void registerJsonPathMappingProvider() {
        this.graphQlClientBuilder.codecConfigurer(codecConfigurer -> this.configureJsonPathConfig(jsonPathConfig -> {
            EncoderDecoderMappingProvider provider = new EncoderDecoderMappingProvider((CodecConfigurer)codecConfigurer);
            return jsonPathConfig.mappingProvider((MappingProvider)provider);
        }));
    }

    private static class DefaultWebSocketGraphQlTester
    extends AbstractDelegatingGraphQlTester
    implements WebSocketGraphQlTester {
        private final WebSocketGraphQlClient client;
        private final Consumer<AbstractGraphQlTesterBuilder<?>> builderInitializer;

        private DefaultWebSocketGraphQlTester(GraphQlTester graphQlTester, WebSocketGraphQlClient client, Consumer<AbstractGraphQlTesterBuilder<?>> builderInitializer) {
            super(graphQlTester);
            this.client = client;
            this.builderInitializer = builderInitializer;
        }

        @Override
        public Mono<Void> start() {
            return this.client.start();
        }

        @Override
        public Mono<Void> stop() {
            return this.client.stop();
        }

        @Override
        public DefaultWebSocketGraphQlTesterBuilder mutate() {
            DefaultWebSocketGraphQlTesterBuilder builder = new DefaultWebSocketGraphQlTesterBuilder(this.client);
            this.builderInitializer.accept(builder);
            return builder;
        }
    }
}

