/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import java.lang.reflect.Method;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;

class HandlerMethodInputValidator {
    private final Validator validator;

    public HandlerMethodInputValidator(Validator validator) {
        Assert.notNull((Object)validator, (String)"validator should not be null");
        this.validator = validator instanceof LocalValidatorFactoryBean ? ((LocalValidatorFactoryBean)validator).getValidator() : (validator instanceof SpringValidatorAdapter ? (Validator)validator.unwrap(Validator.class) : validator);
    }

    public HandlerMethodInputValidator() {
        this(Validation.buildDefaultValidatorFactory().getValidator());
    }

    public void validate(HandlerMethod handlerMethod, Object[] arguments) {
        Class[] validationGroups = this.determineValidationGroups(handlerMethod);
        Set result = this.validator.forExecutables().validateParameters(handlerMethod.getBean(), handlerMethod.getMethod(), arguments, validationGroups);
        if (!result.isEmpty()) {
            throw new ConstraintViolationException(result);
        }
    }

    private Class<?>[] determineValidationGroups(HandlerMethod method) {
        Validated validatedAnn = (Validated)AnnotationUtils.findAnnotation((Method)method.getMethod(), Validated.class);
        if (validatedAnn == null) {
            validatedAnn = (Validated)AnnotationUtils.findAnnotation(method.getBeanType(), Validated.class);
        }
        return validatedAnn != null ? validatedAnn.value() : new Class[]{};
    }
}

