/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server;

import java.net.URI;
import java.util.Locale;
import java.util.Map;
import org.springframework.graphql.ExecutionGraphQlRequest;
import org.springframework.graphql.support.DefaultExecutionGraphQlRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class WebGraphQlRequest
extends DefaultExecutionGraphQlRequest
implements ExecutionGraphQlRequest {
    private final UriComponents uri;
    private final HttpHeaders headers;

    public WebGraphQlRequest(URI uri, HttpHeaders headers, Map<String, Object> body, String id, @Nullable Locale locale) {
        super((String)WebGraphQlRequest.getKey("query", body), (String)WebGraphQlRequest.getKey("operationName", body), (Map)WebGraphQlRequest.getKey("variables", body), (Map)WebGraphQlRequest.getKey("extensions", body), id, locale);
        Assert.notNull((Object)uri, (String)"URI is required'");
        Assert.notNull((Object)headers, (String)"HttpHeaders is required'");
        this.uri = UriComponentsBuilder.fromUri((URI)uri).build(true);
        this.headers = headers;
    }

    private static <T> T getKey(String key, Map<String, Object> body) {
        if (key.equals("query") && !StringUtils.hasText((String)((String)body.get(key)))) {
            throw new ServerWebInputException("No \"query\" in the request document");
        }
        return (T)body.get(key);
    }

    public UriComponents getUri() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }
}

