/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data;

import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Consumer;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.CollectionFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.DefaultBindingErrorProcessor;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class GraphQlArgumentBinder {
    private static final int DEFAULT_AUTO_GROW_COLLECTION_LIMIT = 1024;
    @Nullable
    private final SimpleTypeConverter typeConverter;
    private final BindingErrorProcessor bindingErrorProcessor = new DefaultBindingErrorProcessor();
    private List<Consumer<DataBinder>> dataBinderInitializers = new ArrayList<Consumer<DataBinder>>();

    public GraphQlArgumentBinder() {
        this(null);
    }

    public GraphQlArgumentBinder(@Nullable ConversionService conversionService) {
        if (conversionService != null) {
            this.typeConverter = new SimpleTypeConverter();
            this.typeConverter.setConversionService(conversionService);
        } else {
            this.typeConverter = null;
        }
    }

    private SimpleTypeConverter getTypeConverter() {
        return this.typeConverter != null ? this.typeConverter : new SimpleTypeConverter();
    }

    @Nullable
    private ConversionService getConversionService() {
        return this.typeConverter != null ? this.typeConverter.getConversionService() : null;
    }

    public void addDataBinderInitializer(Consumer<DataBinder> dataBinderInitializer) {
        this.dataBinderInitializers.add(dataBinderInitializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object bind(DataFetchingEnvironment environment, @Nullable String argumentName, ResolvableType targetType) throws BindException {
        Object rawValue;
        Object object = rawValue = argumentName != null ? environment.getArgument(argumentName) : environment.getArguments();
        if (rawValue == null) {
            return this.wrapAsOptionalIfNecessary(null, targetType);
        }
        Class targetClass = targetType.resolve();
        Assert.notNull((Object)targetClass, (String)("Could not determine target type from " + targetType));
        DataBinder binder = new DataBinder(null, argumentName != null ? argumentName : "arguments");
        this.initDataBinder(binder);
        BindingResult bindingResult = binder.getBindingResult();
        Stack<String> segments = new Stack<String>();
        try {
            if (this.isApproximableCollectionType(rawValue)) {
                segments.push(argumentName);
                Collection collection = this.createCollection((Collection)rawValue, targetType, bindingResult, segments);
                return collection;
            }
            if (targetClass == Optional.class) {
                targetClass = targetType.getNested(2).resolve();
                Assert.notNull((Object)targetClass, (String)("Could not determine Optional<T> type from " + targetType));
            }
            if (rawValue instanceof Map) {
                Object target = this.createValue((Map)rawValue, targetClass, bindingResult, segments);
                Object object2 = this.wrapAsOptionalIfNecessary(target, targetType);
                return object2;
            }
            if (targetClass.isInstance(rawValue)) {
                Object target = this.wrapAsOptionalIfNecessary(rawValue, targetType);
                return target;
            }
            Object target = this.convertValue(rawValue, targetClass, bindingResult, segments);
            Object object3 = this.wrapAsOptionalIfNecessary(target, targetType);
            return object3;
        }
        finally {
            this.checkBindingResult(bindingResult);
        }
    }

    private void initDataBinder(DataBinder binder) {
        binder.setAutoGrowCollectionLimit(1024);
        this.dataBinderInitializers.forEach(initializer -> initializer.accept(binder));
    }

    @Nullable
    private Object wrapAsOptionalIfNecessary(@Nullable Object value, ResolvableType type) {
        return type.resolve(Object.class).equals(Optional.class) ? Optional.ofNullable(value) : value;
    }

    private boolean isApproximableCollectionType(@Nullable Object rawValue) {
        return rawValue != null && (CollectionFactory.isApproximableCollectionType(rawValue.getClass()) || rawValue instanceof List);
    }

    private <T> Collection<T> createCollection(Collection<Object> rawCollection, ResolvableType collectionType, BindingResult bindingResult, Stack<String> segments) {
        if (!Collection.class.isAssignableFrom(collectionType.resolve())) {
            bindingResult.rejectValue(this.toArgumentPath(segments), "typeMismatch", "Expected collection: " + collectionType);
            return Collections.emptyList();
        }
        Class elementClass = collectionType.asCollection().getGeneric(new int[]{0}).resolve();
        if (elementClass == null) {
            bindingResult.rejectValue(this.toArgumentPath(segments), "unknownElementType", "Unknown element type");
            return Collections.emptyList();
        }
        Collection collection = CollectionFactory.createCollection((Class)collectionType.getRawClass(), (Class)elementClass, (int)rawCollection.size());
        int i = 0;
        for (Object rawValue : rawCollection) {
            segments.push("[" + i++ + "]");
            if (rawValue == null || elementClass.isAssignableFrom(rawValue.getClass())) {
                collection.add(rawValue);
            } else if (rawValue instanceof Map) {
                collection.add(this.createValueOrNull((Map)rawValue, elementClass, bindingResult, segments));
            } else {
                collection.add(this.convertValue(rawValue, elementClass, bindingResult, segments));
            }
            segments.pop();
        }
        return collection;
    }

    @Nullable
    private Object createValueOrNull(Map<String, Object> rawMap, Class<?> targetType, BindingResult result, Stack<String> segments) {
        try {
            return this.createValue(rawMap, targetType, result, segments);
        }
        catch (BindException ex) {
            return null;
        }
    }

    private Object createValue(Map<String, Object> rawMap, Class<?> targetType, BindingResult bindingResult, Stack<String> segments) throws BindException {
        Constructor ctor = BeanUtils.getResolvableConstructor(targetType);
        if (ctor.getParameterCount() == 0) {
            Object target = BeanUtils.instantiateClass((Constructor)ctor, (Object[])new Object[0]);
            DataBinder dataBinder = new DataBinder(target);
            this.initDataBinder(dataBinder);
            dataBinder.getBindingResult().setNestedPath(this.toArgumentPath(segments));
            dataBinder.setConversionService(this.getConversionService());
            dataBinder.bind((PropertyValues)this.initBindValues(rawMap));
            if (dataBinder.getBindingResult().hasErrors()) {
                this.addErrors(dataBinder, bindingResult, segments);
                throw new BindException(bindingResult);
            }
            return target;
        }
        if (!segments.isEmpty()) {
            segments.push(".");
        }
        String[] paramNames = BeanUtils.getParameterNames((Constructor)ctor);
        Class<?>[] paramTypes = ctor.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            Object rawValue = rawMap.get(paramName);
            segments.push(paramName);
            MethodParameter methodParam = new MethodParameter(ctor, i);
            if (rawValue == null && methodParam.isOptional()) {
                args[i] = paramTypes[i] == Optional.class ? Optional.empty() : null;
            } else if (paramTypes[i] == Object.class) {
                args[i] = rawValue;
            } else if (this.isApproximableCollectionType(rawValue)) {
                ResolvableType elementType = ResolvableType.forMethodParameter((MethodParameter)methodParam);
                args[i] = this.createCollection((Collection)rawValue, elementType, bindingResult, segments);
            } else if (rawValue instanceof Map) {
                boolean isOptional = paramTypes[i] == Optional.class;
                Class<?> type = isOptional ? methodParam.nestedIfOptional().getNestedParameterType() : paramTypes[i];
                Optional<Object> value = this.createValueOrNull((Map)rawValue, type, bindingResult, segments);
                args[i] = isOptional ? Optional.ofNullable(value) : value;
            } else {
                args[i] = this.convertValue(rawValue, paramTypes[i], new TypeDescriptor(methodParam), bindingResult, segments);
            }
            segments.pop();
        }
        if (segments.size() > 1) {
            segments.pop();
        }
        try {
            return BeanUtils.instantiateClass((Constructor)ctor, (Object[])args);
        }
        catch (BeanInstantiationException ex) {
            this.checkBindingResult(bindingResult);
            throw ex;
        }
    }

    private MutablePropertyValues initBindValues(Map<String, Object> rawMap) {
        MutablePropertyValues mpvs = new MutablePropertyValues();
        Stack<String> segments = new Stack<String>();
        for (String key : rawMap.keySet()) {
            this.addBindValues(mpvs, key, rawMap.get(key), segments);
        }
        return mpvs;
    }

    private void addBindValues(MutablePropertyValues mpvs, String name, Object value, Stack<String> segments) {
        if (value instanceof List) {
            List items = (List)value;
            if (items.isEmpty()) {
                segments.push(name);
                mpvs.add(this.toArgumentPath(segments), value);
                segments.pop();
            } else {
                for (int i = 0; i < items.size(); ++i) {
                    this.addBindValues(mpvs, name + "[" + i + "]", items.get(i), segments);
                }
            }
        } else if (value instanceof Map) {
            segments.push(name + ".");
            Map map = (Map)value;
            for (String key : map.keySet()) {
                this.addBindValues(mpvs, key, map.get(key), segments);
            }
            segments.pop();
        } else {
            segments.push(name);
            mpvs.add(this.toArgumentPath(segments), value);
            segments.pop();
        }
    }

    private String toArgumentPath(Stack<String> path) {
        StringBuilder sb = new StringBuilder();
        path.forEach(sb::append);
        return sb.toString();
    }

    @Nullable
    private <T> T convertValue(@Nullable Object rawValue, Class<T> type, BindingResult result, Stack<String> segments) {
        return (T)this.convertValue(rawValue, type, TypeDescriptor.valueOf(type), result, segments);
    }

    @Nullable
    private Object convertValue(@Nullable Object rawValue, Class<?> type, TypeDescriptor descriptor, BindingResult bindingResult, Stack<String> segments) {
        try {
            return this.getTypeConverter().convertIfNecessary(rawValue, type, descriptor);
        }
        catch (TypeMismatchException ex) {
            String name = this.toArgumentPath(segments);
            ex.initPropertyName(name);
            bindingResult.recordFieldValue(name, type, rawValue);
            this.bindingErrorProcessor.processPropertyAccessException((PropertyAccessException)ex, bindingResult);
            return null;
        }
    }

    private void addErrors(DataBinder binder, BindingResult bindingResult, Stack<String> segments) {
        String path = !segments.isEmpty() ? this.toArgumentPath(segments) + "." : "";
        binder.getBindingResult().getFieldErrors().forEach(error -> bindingResult.addError((ObjectError)new FieldError(bindingResult.getObjectName(), path + error.getField(), error.getRejectedValue(), error.isBindingFailure(), error.getCodes(), error.getArguments(), error.getDefaultMessage())));
    }

    private void checkBindingResult(BindingResult bindingResult) throws BindException {
        if (bindingResult.hasErrors()) {
            throw new BindException(bindingResult);
        }
    }
}

