/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.observation;

import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.execution.DataFetcherResult;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.graphql.observation.DataFetcherObservationContext;
import org.springframework.graphql.observation.DataFetcherObservationConvention;
import org.springframework.graphql.observation.DefaultDataFetcherObservationConvention;
import org.springframework.graphql.observation.DefaultExecutionRequestObservationConvention;
import org.springframework.graphql.observation.ExecutionRequestObservationContext;
import org.springframework.graphql.observation.ExecutionRequestObservationConvention;
import org.springframework.graphql.observation.GraphQlObservationDocumentation;
import org.springframework.lang.Nullable;

public class GraphQlObservationInstrumentation
extends SimpleInstrumentation {
    private static final Log logger = LogFactory.getLog(GraphQlObservationInstrumentation.class);
    private static final ExecutionRequestObservationConvention DEFAULT_REQUEST_CONVENTION = new DefaultExecutionRequestObservationConvention();
    private static final DataFetcherObservationConvention DEFAULT_DATA_FETCHER_CONVENTION = new DefaultDataFetcherObservationConvention();
    private final ObservationRegistry observationRegistry;
    private final ExecutionRequestObservationConvention requestObservationConvention;
    private final DataFetcherObservationConvention dataFetcherObservationConvention;

    public GraphQlObservationInstrumentation(ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
        this.requestObservationConvention = new DefaultExecutionRequestObservationConvention();
        this.dataFetcherObservationConvention = new DefaultDataFetcherObservationConvention();
    }

    public GraphQlObservationInstrumentation(ObservationRegistry observationRegistry, ExecutionRequestObservationConvention requestObservationConvention, DataFetcherObservationConvention dateFetcherObservationConvention) {
        this.observationRegistry = observationRegistry;
        this.requestObservationConvention = requestObservationConvention;
        this.dataFetcherObservationConvention = dateFetcherObservationConvention;
    }

    public InstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        return RequestObservationInstrumentationState.INSTANCE;
    }

    public InstrumentationContext<ExecutionResult> beginExecution(InstrumentationExecutionParameters parameters, InstrumentationState state) {
        if (state instanceof RequestObservationInstrumentationState) {
            RequestObservationInstrumentationState instrumentationState = (RequestObservationInstrumentationState)state;
            final ExecutionRequestObservationContext observationContext = new ExecutionRequestObservationContext(parameters.getExecutionInput());
            final Observation requestObservation = GraphQlObservationDocumentation.EXECUTION_REQUEST.observation(this.requestObservationConvention, DEFAULT_REQUEST_CONVENTION, () -> observationContext, this.observationRegistry);
            requestObservation.parentObservation(GraphQlObservationInstrumentation.getCurrentObservation(parameters.getGraphQLContext()));
            GraphQLContext graphQLContext = parameters.getGraphQLContext();
            graphQLContext.put((Object)"micrometer.observation", (Object)requestObservation);
            requestObservation.start();
            return new SimpleInstrumentationContext<ExecutionResult>(){

                public void onCompleted(ExecutionResult result, Throwable exc) {
                    observationContext.setExecutionResult(result);
                    if (exc != null) {
                        requestObservation.error(exc);
                    }
                    requestObservation.stop();
                }
            };
        }
        return super.beginExecution(parameters, state);
    }

    @Nullable
    private static Observation getCurrentObservation(GraphQLContext graphQLContext) {
        return (Observation)graphQLContext.get((Object)"micrometer.observation");
    }

    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        if (!parameters.isTrivialDataFetcher() && state instanceof RequestObservationInstrumentationState) {
            RequestObservationInstrumentationState instrumentationState = (RequestObservationInstrumentationState)state;
            return environment -> {
                DataFetcherObservationContext observationContext = new DataFetcherObservationContext(parameters.getEnvironment());
                Observation dataFetcherObservation = GraphQlObservationDocumentation.DATA_FETCHER.observation(this.dataFetcherObservationConvention, DEFAULT_DATA_FETCHER_CONVENTION, () -> observationContext, this.observationRegistry);
                dataFetcherObservation.parentObservation(GraphQlObservationInstrumentation.getCurrentObservation(environment));
                dataFetcherObservation.start();
                try {
                    Object value = dataFetcher.get(environment);
                    if (value instanceof CompletionStage) {
                        CompletionStage completion = (CompletionStage)value;
                        return completion.handle((result, error) -> {
                            observationContext.setValue(result);
                            if (error != null) {
                                dataFetcherObservation.error(error);
                                dataFetcherObservation.stop();
                                throw new CompletionException((Throwable)error);
                            }
                            dataFetcherObservation.stop();
                            return GraphQlObservationInstrumentation.wrapAsDataFetcherResult(result, dataFetcherObservation);
                        });
                    }
                    observationContext.setValue(value);
                    dataFetcherObservation.stop();
                    return GraphQlObservationInstrumentation.wrapAsDataFetcherResult(value, dataFetcherObservation);
                }
                catch (Throwable throwable) {
                    dataFetcherObservation.error(throwable);
                    dataFetcherObservation.stop();
                    throw throwable;
                }
            };
        }
        return dataFetcher;
    }

    @Nullable
    private static Observation getCurrentObservation(DataFetchingEnvironment environment) {
        Observation currentObservation = null;
        if (environment.getLocalContext() != null && environment.getLocalContext() instanceof GraphQLContext) {
            GraphQLContext localContext = (GraphQLContext)environment.getLocalContext();
            currentObservation = (Observation)localContext.get((Object)"micrometer.observation");
        }
        if (currentObservation == null) {
            return (Observation)environment.getGraphQlContext().get((Object)"micrometer.observation");
        }
        return currentObservation;
    }

    private static DataFetcherResult<?> wrapAsDataFetcherResult(Object value, Observation dataFetcherObservation) {
        if (value instanceof DataFetcherResult) {
            DataFetcherResult result = (DataFetcherResult)value;
            if (result.getLocalContext() == null) {
                return result.transform(builder -> builder.localContext((Object)GraphQLContext.newContext().of((Object)"micrometer.observation", (Object)dataFetcherObservation).build()));
            }
            if (result.getLocalContext() instanceof GraphQLContext) {
                ((GraphQLContext)result.getLocalContext()).put((Object)"micrometer.observation", (Object)dataFetcherObservation);
            } else {
                logger.debug((Object)("Cannot add observation to localContext as it is not a GraphQLContext but a " + result.getLocalContext().getClass().toString()));
            }
            return result;
        }
        return DataFetcherResult.newResult().data(value).localContext((Object)GraphQLContext.newContext().of((Object)"micrometer.observation", (Object)dataFetcherObservation).build()).build();
    }

    static class RequestObservationInstrumentationState
    implements InstrumentationState {
        static final RequestObservationInstrumentationState INSTANCE = new RequestObservationInstrumentationState();

        RequestObservationInstrumentationState() {
        }
    }
}

