/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.GraphQLError;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.idl.RuntimeWiring;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataloader.DataLoader;
import org.reactivestreams.Publisher;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.expression.BeanResolver;
import org.springframework.format.FormatterRegistrar;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.graphql.data.GraphQlArgumentBinder;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolverComposite;
import org.springframework.graphql.data.method.annotation.BatchMapping;
import org.springframework.graphql.data.method.annotation.SchemaMapping;
import org.springframework.graphql.data.method.annotation.support.AnnotatedControllerExceptionResolver;
import org.springframework.graphql.data.method.annotation.support.ArgumentMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ArgumentsMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.AuthenticationPrincipalArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.BatchLoaderHandlerMethod;
import org.springframework.graphql.data.method.annotation.support.ContextValueMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ContinuationHandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.DataFetcherHandlerMethod;
import org.springframework.graphql.data.method.annotation.support.DataFetchingEnvironmentMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.DataLoaderMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.LocalContextValueMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.PrincipalMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ProjectedPayloadMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ScrollSubrangeMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.SortMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.SourceMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.SubrangeMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ValidationHelper;
import org.springframework.graphql.data.pagination.CursorStrategy;
import org.springframework.graphql.data.query.SortStrategy;
import org.springframework.graphql.execution.BatchLoaderRegistry;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.graphql.execution.SelfDescribingDataFetcher;
import org.springframework.graphql.execution.SubscriptionPublisherException;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AnnotatedControllerConfigurer
implements ApplicationContextAware,
InitializingBean,
RuntimeWiringConfigurer {
    private static final ClassLoader classLoader = AnnotatedControllerConfigurer.class.getClassLoader();
    private static final boolean springDataPresent = ClassUtils.isPresent((String)"org.springframework.data.projection.SpelAwareProxyProjectionFactory", (ClassLoader)classLoader);
    private static final boolean springSecurityPresent = ClassUtils.isPresent((String)"org.springframework.security.core.context.SecurityContext", (ClassLoader)classLoader);
    private static final boolean beanValidationPresent = ClassUtils.isPresent((String)"jakarta.validation.executable.ExecutableValidator", (ClassLoader)classLoader);
    private static final Log logger = LogFactory.getLog(AnnotatedControllerConfigurer.class);
    private static final String SCOPED_TARGET_NAME_PREFIX = "scopedTarget.";
    private final FormattingConversionService conversionService = new DefaultFormattingConversionService();
    private boolean fallBackOnDirectFieldAccess;
    private final List<HandlerMethodArgumentResolver> customArgumentResolvers = new ArrayList<HandlerMethodArgumentResolver>(8);
    @Nullable
    private HandlerMethodArgumentResolverComposite argumentResolvers;
    @Nullable
    private ValidationHelper validationHelper;
    @Nullable
    private AnnotatedControllerExceptionResolver exceptionResolver;
    @Nullable
    private Executor executor;
    @Nullable
    private ApplicationContext applicationContext;

    public void addFormatterRegistrar(FormatterRegistrar registrar) {
        registrar.registerFormatters((FormatterRegistry)this.conversionService);
    }

    public void setFallBackOnDirectFieldAccess(boolean fallBackOnDirectFieldAccess) {
        this.fallBackOnDirectFieldAccess = fallBackOnDirectFieldAccess;
    }

    public void addCustomArgumentResolver(HandlerMethodArgumentResolver resolver) {
        this.customArgumentResolvers.add(resolver);
    }

    HandlerMethodArgumentResolverComposite getArgumentResolvers() {
        Assert.notNull((Object)this.argumentResolvers, (String)"HandlerMethodArgumentResolverComposite is not yet initialized, was afterPropertiesSet called?");
        return this.argumentResolvers;
    }

    public DataFetcherExceptionResolver getExceptionResolver() {
        Assert.notNull((Object)this.exceptionResolver, (String)"DataFetcherExceptionResolver is not yet initialized, was afterPropertiesSet called?");
        return (ex, env) -> this.exceptionResolver.resolveException(ex, env, null);
    }

    @Deprecated(since="1.1.0", forRemoval=true)
    public void setDataBinderInitializer(@Nullable Consumer<DataBinder> consumer) {
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        this.argumentResolvers = this.initArgumentResolvers();
        this.exceptionResolver = new AnnotatedControllerExceptionResolver(this.argumentResolvers);
        if (this.applicationContext != null) {
            this.exceptionResolver.registerControllerAdvice(this.applicationContext);
        }
        if (beanValidationPresent) {
            this.validationHelper = ValidationHelper.createIfValidatorPresent(this.obtainApplicationContext());
        }
    }

    private HandlerMethodArgumentResolverComposite initArgumentResolvers() {
        HandlerMethodArgumentResolverComposite resolvers = new HandlerMethodArgumentResolverComposite();
        if (springDataPresent) {
            resolvers.addResolver(new ProjectedPayloadMethodArgumentResolver(this.obtainApplicationContext()));
        }
        GraphQlArgumentBinder argumentBinder = new GraphQlArgumentBinder((ConversionService)this.conversionService, this.fallBackOnDirectFieldAccess);
        resolvers.addResolver(new ArgumentMethodArgumentResolver(argumentBinder));
        resolvers.addResolver(new ArgumentsMethodArgumentResolver(argumentBinder));
        resolvers.addResolver(new ContextValueMethodArgumentResolver());
        resolvers.addResolver(new LocalContextValueMethodArgumentResolver());
        if (springSecurityPresent) {
            ApplicationContext context = this.obtainApplicationContext();
            resolvers.addResolver(new AuthenticationPrincipalArgumentResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)context)));
        }
        resolvers.addResolver(new DataFetchingEnvironmentMethodArgumentResolver());
        resolvers.addResolver(new DataLoaderMethodArgumentResolver());
        this.addSubrangeMethodArgumentResolver(resolvers);
        this.addSortMethodArgumentResolver(resolvers);
        if (springSecurityPresent) {
            resolvers.addResolver(new PrincipalMethodArgumentResolver());
        }
        if (KotlinDetector.isKotlinPresent()) {
            resolvers.addResolver(new ContinuationHandlerMethodArgumentResolver());
        }
        this.customArgumentResolvers.forEach(resolvers::addResolver);
        resolvers.addResolver(new SourceMethodArgumentResolver());
        return resolvers;
    }

    private void addSubrangeMethodArgumentResolver(HandlerMethodArgumentResolverComposite resolvers) {
        try {
            CursorStrategy strategy = (CursorStrategy)this.obtainApplicationContext().getBean(CursorStrategy.class);
            if (springDataPresent && strategy.supports(ScrollPosition.class)) {
                CursorStrategy strategyToUse = strategy;
                resolvers.addResolver(new ScrollSubrangeMethodArgumentResolver(strategyToUse));
                return;
            }
            resolvers.addResolver(new SubrangeMethodArgumentResolver(strategy));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    private void addSortMethodArgumentResolver(HandlerMethodArgumentResolverComposite resolvers) {
        if (springDataPresent) {
            try {
                SortStrategy strategy = (SortStrategy)this.obtainApplicationContext().getBean(SortStrategy.class);
                resolvers.addResolver(new SortMethodArgumentResolver(strategy));
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
    }

    protected final ApplicationContext obtainApplicationContext() {
        Assert.state((this.applicationContext != null ? 1 : 0) != 0, (String)"No ApplicationContext");
        return this.applicationContext;
    }

    @Override
    public void configure(RuntimeWiring.Builder runtimeWiringBuilder) {
        Assert.state((this.argumentResolvers != null ? 1 : 0) != 0, (String)"`argumentResolvers` is not initialized");
        Assert.state((this.exceptionResolver != null ? 1 : 0) != 0, (String)"`exceptionResolver` is not initialized");
        this.findHandlerMethods().forEach(info -> {
            SchemaMappingDataFetcher dataFetcher = !info.isBatchMapping() ? new SchemaMappingDataFetcher((MappingInfo)info, this.argumentResolvers, this.validationHelper, this.exceptionResolver, this.executor) : this.registerBatchLoader((MappingInfo)info);
            runtimeWiringBuilder.type(info.getCoordinates().getTypeName(), typeBuilder -> typeBuilder.dataFetcher(info.getCoordinates().getFieldName(), dataFetcher));
        });
    }

    private Collection<MappingInfo> findHandlerMethods() {
        ApplicationContext context = this.obtainApplicationContext();
        HashMap result = new HashMap();
        for (String beanName : context.getBeanNamesForType(Object.class)) {
            Class beanType;
            block3: {
                if (beanName.startsWith(SCOPED_TARGET_NAME_PREFIX)) continue;
                beanType = null;
                try {
                    beanType = context.getType(beanName);
                }
                catch (Throwable ex) {
                    if (!logger.isTraceEnabled()) break block3;
                    logger.trace((Object)("Could not resolve type for bean '" + beanName + "'"), ex);
                }
            }
            if (beanType == null || !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)beanType, Controller.class)) continue;
            Class beanClass = context.getType(beanName);
            this.findHandlerMethods(beanName, beanClass).forEach(info -> {
                HandlerMethod handlerMethod = info.getHandlerMethod();
                MappingInfo existing = result.put(info.getCoordinates(), info);
                if (existing != null && !existing.getHandlerMethod().equals(handlerMethod)) {
                    throw new IllegalStateException("Ambiguous mapping. Cannot map '" + handlerMethod.getBean() + "' method \n" + handlerMethod + "\nto " + info.getCoordinates() + ": There is already '" + existing.getHandlerMethod().getBean() + "' bean method\n" + existing + " mapped.");
                }
            });
        }
        return result.values();
    }

    private Collection<MappingInfo> findHandlerMethods(Object handler, @Nullable Class<?> handlerClass) {
        if (handlerClass == null) {
            return Collections.emptyList();
        }
        Class userClass = ClassUtils.getUserClass(handlerClass);
        Map map = MethodIntrospector.selectMethods((Class)userClass, method -> this.getMappingInfo(method, handler, userClass));
        Collection<MappingInfo> mappingInfos = map.values();
        if (logger.isTraceEnabled() && !mappingInfos.isEmpty()) {
            logger.trace((Object)this.formatMappings(userClass, mappingInfos));
        }
        return mappingInfos;
    }

    @Nullable
    private MappingInfo getMappingInfo(Method method, Object handler, Class<?> handlerType) {
        String field;
        String typeName;
        SchemaMapping mapping;
        Set annotations = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, new LinkedHashSet<Class>(Arrays.asList(BatchMapping.class, SchemaMapping.class)));
        if (annotations.isEmpty()) {
            return null;
        }
        if (annotations.size() != 1) {
            throw new IllegalArgumentException("Expected either @BatchMapping or @SchemaMapping, not both: " + method.toGenericString());
        }
        boolean batchMapping = false;
        int batchSize = -1;
        HandlerMethod handlerMethod = this.createHandlerMethod(method, handler, handlerType);
        Annotation annotation = (Annotation)annotations.iterator().next();
        if (annotation instanceof SchemaMapping) {
            mapping = (SchemaMapping)annotation;
            typeName = mapping.typeName();
            field = StringUtils.hasText((String)mapping.field()) ? mapping.field() : method.getName();
        } else {
            BatchMapping mapping2 = (BatchMapping)annotation;
            typeName = mapping2.typeName();
            field = StringUtils.hasText((String)mapping2.field()) ? mapping2.field() : method.getName();
            batchMapping = true;
            batchSize = mapping2.maxBatchSize();
        }
        if (!StringUtils.hasText((String)typeName) && (mapping = (SchemaMapping)AnnotatedElementUtils.findMergedAnnotation(handlerType, SchemaMapping.class)) != null) {
            typeName = mapping.typeName();
        }
        if (!StringUtils.hasText((String)typeName)) {
            for (MethodParameter parameter : handlerMethod.getMethodParameters()) {
                if (!batchMapping) {
                    Assert.state((this.argumentResolvers != null ? 1 : 0) != 0, (String)"`argumentResolvers` is not initialized");
                    HandlerMethodArgumentResolver resolver = this.argumentResolvers.getArgumentResolver(parameter);
                    if (!(resolver instanceof SourceMethodArgumentResolver)) continue;
                    typeName = parameter.getParameterType().getSimpleName();
                    break;
                }
                if (!Collection.class.isAssignableFrom(parameter.getParameterType())) continue;
                typeName = parameter.nested().getNestedParameterType().getSimpleName();
                break;
            }
        }
        Assert.hasText((String)typeName, (String)("No parentType specified, and a source/parent method argument was also not found: " + handlerMethod.getShortLogMessage()));
        return new MappingInfo(typeName, field, batchMapping, batchSize, handlerMethod);
    }

    private HandlerMethod createHandlerMethod(Method method, Object handler, Class<?> handlerType) {
        Method theMethod = AopUtils.selectInvocableMethod((Method)method, handlerType);
        return handler instanceof String ? new HandlerMethod((String)handler, (BeanFactory)this.obtainApplicationContext().getAutowireCapableBeanFactory(), theMethod) : new HandlerMethod(handler, theMethod);
    }

    private String formatMappings(Class<?> handlerType, Collection<MappingInfo> infos) {
        String formattedType = Arrays.stream(ClassUtils.getPackageName(handlerType).split("\\.")).map(p -> p.substring(0, 1)).collect(Collectors.joining(".", "", "." + handlerType.getSimpleName()));
        return infos.stream().map(mappingInfo -> {
            Method method = mappingInfo.getHandlerMethod().getMethod();
            String methodParameters = Arrays.stream(method.getGenericParameterTypes()).map(Type::getTypeName).collect(Collectors.joining(",", "(", ")"));
            return mappingInfo.getCoordinates() + " => " + method.getName() + methodParameters;
        }).collect(Collectors.joining("\n\t", "\n\t" + formattedType + ":\n\t", ""));
    }

    private DataFetcher<Object> registerBatchLoader(MappingInfo info) {
        Class clazz;
        MethodParameter returnType;
        BatchLoaderHandlerMethod invocable;
        HandlerMethod handlerMethod;
        BatchLoaderRegistry.RegistrationSpec registration;
        String dataLoaderKey;
        block9: {
            block8: {
                if (!info.isBatchMapping()) {
                    throw new IllegalArgumentException("Not a @BatchMapping method: " + info);
                }
                dataLoaderKey = info.getCoordinates().toString();
                BatchLoaderRegistry registry = (BatchLoaderRegistry)this.obtainApplicationContext().getBean(BatchLoaderRegistry.class);
                registration = registry.forName(dataLoaderKey);
                if (info.getMaxBatchSize() > 0) {
                    registration.withOptions(options -> options.setMaxBatchSize(info.getMaxBatchSize()));
                }
                handlerMethod = info.getHandlerMethod();
                invocable = new BatchLoaderHandlerMethod(handlerMethod, this.executor);
                returnType = handlerMethod.getReturnType();
                clazz = returnType.getParameterType();
                if (clazz.equals(Callable.class)) {
                    returnType = returnType.nested();
                    clazz = returnType.getNestedParameterType();
                }
                if (clazz.equals(Flux.class)) break block8;
                if (!Collection.class.isAssignableFrom(clazz)) break block9;
            }
            registration.registerBatchLoader(invocable::invokeForIterable);
            ResolvableType valueType = ResolvableType.forMethodParameter((MethodParameter)returnType.nested());
            return new BatchMappingDataFetcher(info, valueType, dataLoaderKey);
        }
        if (clazz.equals(Mono.class)) {
            returnType = returnType.nested();
            clazz = returnType.getNestedParameterType();
        }
        if (Map.class.isAssignableFrom(clazz)) {
            registration.registerMappedBatchLoader(invocable::invokeForMap);
            ResolvableType valueType = ResolvableType.forMethodParameter((MethodParameter)returnType.nested(Integer.valueOf(1)));
            return new BatchMappingDataFetcher(info, valueType, dataLoaderKey);
        }
        throw new IllegalStateException("@BatchMapping method is expected to return Mono<Map<K, V>>, Map<K, V>, Flux<V>, or Collection<V>: " + handlerMethod);
    }

    public void configure(GraphQLCodeRegistry.Builder codeRegistryBuilder) {
        RuntimeWiring.Builder wiringBuilder = RuntimeWiring.newRuntimeWiring();
        this.configure(wiringBuilder);
        RuntimeWiring runtimeWiring = wiringBuilder.build();
        runtimeWiring.getDataFetchers().forEach((typeName, dataFetcherMap) -> dataFetcherMap.forEach((key, value) -> {
            FieldCoordinates coordinates = FieldCoordinates.coordinates((String)typeName, (String)key);
            codeRegistryBuilder.dataFetcher(coordinates, value);
        }));
    }

    private static class MappingInfo {
        private final FieldCoordinates coordinates;
        private final boolean batchMapping;
        private final int maxBatchSize;
        private final HandlerMethod handlerMethod;

        MappingInfo(String typeName, String field, boolean batchMapping, int maxBatchSize, HandlerMethod handlerMethod) {
            this.coordinates = FieldCoordinates.coordinates((String)typeName, (String)field);
            this.batchMapping = batchMapping;
            this.maxBatchSize = maxBatchSize;
            this.handlerMethod = handlerMethod;
        }

        FieldCoordinates getCoordinates() {
            return this.coordinates;
        }

        boolean isBatchMapping() {
            return this.batchMapping;
        }

        int getMaxBatchSize() {
            return this.maxBatchSize;
        }

        HandlerMethod getHandlerMethod() {
            return this.handlerMethod;
        }

        public String toString() {
            return this.coordinates + " -> " + this.handlerMethod;
        }
    }

    static class BatchMappingDataFetcher
    implements DataFetcher<Object>,
    SelfDescribingDataFetcher<Object> {
        private final MappingInfo info;
        private final ResolvableType returnType;
        private final String dataLoaderKey;

        BatchMappingDataFetcher(MappingInfo info, ResolvableType valueType, String dataLoaderKey) {
            this.info = info;
            this.returnType = ResolvableType.forClassWithGenerics(CompletableFuture.class, (ResolvableType[])new ResolvableType[]{valueType});
            this.dataLoaderKey = dataLoaderKey;
        }

        @Override
        public String getDescription() {
            return "@BatchMapping " + this.info.getHandlerMethod().getShortLogMessage();
        }

        @Override
        public ResolvableType getReturnType() {
            return this.returnType;
        }

        public Object get(DataFetchingEnvironment env) {
            DataLoader dataLoader = env.getDataLoaderRegistry().getDataLoader(this.dataLoaderKey);
            Assert.state((dataLoader != null ? 1 : 0) != 0, (String)("No DataLoader for key '" + this.dataLoaderKey + "'"));
            return env.getLocalContext() != null ? dataLoader.load(env.getSource(), env.getLocalContext()) : dataLoader.load(env.getSource());
        }
    }

    static class SchemaMappingDataFetcher
    implements SelfDescribingDataFetcher<Object> {
        private final MappingInfo info;
        private final HandlerMethodArgumentResolverComposite argumentResolvers;
        @Nullable
        private final BiConsumer<Object, Object[]> methodValidationHelper;
        private final AnnotatedControllerExceptionResolver exceptionResolver;
        @Nullable
        private final Executor executor;
        private final boolean subscription;

        SchemaMappingDataFetcher(MappingInfo info, HandlerMethodArgumentResolverComposite argumentResolvers, @Nullable ValidationHelper helper, AnnotatedControllerExceptionResolver exceptionResolver, @Nullable Executor executor) {
            this.info = info;
            this.argumentResolvers = argumentResolvers;
            this.methodValidationHelper = helper != null ? helper.getValidationHelperFor(info.getHandlerMethod()) : null;
            Class<?> controllerType = info.getHandlerMethod().getBeanType();
            exceptionResolver.registerController(controllerType);
            this.exceptionResolver = exceptionResolver;
            this.executor = executor;
            this.subscription = this.info.getCoordinates().getTypeName().equalsIgnoreCase("Subscription");
        }

        @Override
        public String getDescription() {
            return this.info.getHandlerMethod().getShortLogMessage();
        }

        @Override
        public ResolvableType getReturnType() {
            return ResolvableType.forMethodReturnType((Method)this.info.getHandlerMethod().getMethod());
        }

        HandlerMethod getHandlerMethod() {
            return this.info.getHandlerMethod();
        }

        public Object get(DataFetchingEnvironment environment) throws Exception {
            DataFetcherHandlerMethod handlerMethod = new DataFetcherHandlerMethod(this.getHandlerMethod(), this.argumentResolvers, this.methodValidationHelper, this.executor, this.subscription);
            try {
                Object result = handlerMethod.invoke(environment);
                return this.applyExceptionHandling(environment, handlerMethod, result);
            }
            catch (Throwable ex) {
                return this.handleException(ex, environment, handlerMethod);
            }
        }

        private <T> Object applyExceptionHandling(DataFetchingEnvironment env, DataFetcherHandlerMethod handlerMethod, Object result) {
            if (this.subscription && result instanceof Publisher) {
                Publisher publisher = (Publisher)result;
                result = Flux.from((Publisher)publisher).onErrorResume(ex -> this.handleSubscriptionError((Throwable)ex, env, handlerMethod));
            } else if (result instanceof Mono) {
                result = ((Mono)result).onErrorResume(ex -> this.handleException((Throwable)ex, env, handlerMethod));
            } else if (result instanceof Flux) {
                result = ((Flux)result).onErrorResume(ex -> this.handleException((Throwable)ex, env, handlerMethod));
            }
            return result;
        }

        private Mono<DataFetcherResult<Object>> handleException(Throwable ex, DataFetchingEnvironment env, DataFetcherHandlerMethod handlerMethod) {
            return this.exceptionResolver.resolveException(ex, env, handlerMethod.getBean()).map(errors -> DataFetcherResult.newResult().errors(errors).build()).switchIfEmpty(Mono.error((Throwable)ex));
        }

        private <T> Publisher<T> handleSubscriptionError(Throwable ex, DataFetchingEnvironment env, DataFetcherHandlerMethod handlerMethod) {
            return this.exceptionResolver.resolveException(ex, env, handlerMethod.getBean()).flatMap(errors -> Mono.error((Throwable)((Object)new SubscriptionPublisherException((List<GraphQLError>)errors, ex)))).switchIfEmpty(Mono.error((Throwable)ex));
        }

        public String toString() {
            return this.getDescription();
        }
    }
}

